"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchBurnRateWindows = exports.DEFAULT_BURN_RATE_WINDOWS = void 0;
var _react = require("react");
var _use_fetch_rules_for_slo = require("../../../hooks/use_fetch_rules_for_slo");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_BURN_RATE_WINDOWS = exports.DEFAULT_BURN_RATE_WINDOWS = [{
  name: 'CRITICAL',
  threshold: 14.4,
  longWindow: {
    value: 1,
    unit: 'h'
  },
  shortWindow: {
    value: 5,
    unit: 'm'
  }
}, {
  name: 'HIGH',
  threshold: 6,
  longWindow: {
    value: 6,
    unit: 'h'
  },
  shortWindow: {
    value: 30,
    unit: 'm'
  }
}, {
  name: 'MEDIUM',
  threshold: 3,
  longWindow: {
    value: 24,
    unit: 'h'
  },
  shortWindow: {
    value: 2,
    unit: 'h'
  }
}, {
  name: 'LOW',
  threshold: 1,
  longWindow: {
    value: 72,
    unit: 'h'
  },
  shortWindow: {
    value: 6,
    unit: 'h'
  }
}];
const useFetchBurnRateWindows = slo => {
  const sloId = slo.id;
  const [burnRateWindows, setBurnRateWindows] = (0, _react.useState)(DEFAULT_BURN_RATE_WINDOWS);
  const {
    data: rules,
    isLoading
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: [sloId]
  });
  (0, _react.useEffect)(() => {
    if (!isLoading && rules && rules[sloId]) {
      var _rules$sloId$0$params, _rules$sloId$, _rules$sloId$$params, _rules$sloId$$params$;
      setBurnRateWindows((_rules$sloId$0$params = (_rules$sloId$ = rules[sloId][0]) === null || _rules$sloId$ === void 0 ? void 0 : (_rules$sloId$$params = _rules$sloId$.params) === null || _rules$sloId$$params === void 0 ? void 0 : (_rules$sloId$$params$ = _rules$sloId$$params.windows) === null || _rules$sloId$$params$ === void 0 ? void 0 : _rules$sloId$$params$.map(window => ({
        name: window.actionGroup,
        threshold: window.burnRateThreshold,
        longWindow: window.longWindow,
        shortWindow: window.shortWindow
      }))) !== null && _rules$sloId$0$params !== void 0 ? _rules$sloId$0$params : DEFAULT_BURN_RATE_WINDOWS);
    }
  }, [rules, sloId, isLoading]);
  return burnRateWindows;
};
exports.useFetchBurnRateWindows = useFetchBurnRateWindows;