"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorBudgetHeader = ErrorBudgetHeader;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../../hooks/use_kibana");
var _labels = require("../../../utils/slo/labels");
var _error_budget_actions = require("./error_budget_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/error_budget_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ErrorBudgetHeader({
  slo,
  hideTitle = false,
  hideMetadata = false,
  isMouseOver,
  setDashboardAttachmentReady
}) {
  const {
    executionContext
  } = (0, _use_kibana.useKibana)().services;
  const executionContextName = executionContext.get().name;
  const isDashboardContext = executionContextName === 'dashboards';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, !hideTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "errorBudgetPanelTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.slo.sloDetails.errorBudgetChartPanel.title', {
    defaultMessage: 'Error budget burn down'
  })))), !isDashboardContext && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }, isMouseOver && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_error_budget_actions.ErrorBudgetActions, {
    setDashboardAttachmentReady: setDashboardAttachmentReady,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 19
    }
  }))))), !hideMetadata && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, _sloSchema.rollingTimeWindowTypeSchema.is(slo.timeWindow.type) ? _i18n.i18n.translate('xpack.slo.sloDetails.errorBudgetChartPanel.duration', {
    defaultMessage: 'Last {duration}',
    values: {
      duration: (0, _labels.toDurationLabel)(slo.timeWindow.duration)
    }
  }) : (0, _labels.toDurationAdverbLabel)(slo.timeWindow.duration))));
}