"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSloDetails = useFetchSloDetails;
var _sloSchema = require("@kbn/slo-schema");
var _reactQuery = require("@kbn/react-query");
var _constants = require("../constants");
var _query_key_factory = require("./query_key_factory");
var _use_plugin_context = require("./use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSloDetails({
  sloId,
  instanceId,
  remoteName,
  shouldRefetch
}) {
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.detail(sloId, instanceId, remoteName),
    queryFn: async ({
      signal
    }) => {
      try {
        const response = await sloClient.fetch('GET /api/observability/slos/{id} 2023-10-31', {
          params: {
            path: {
              id: sloId
            },
            query: {
              ...(instanceId !== _sloSchema.ALL_VALUE && {
                instanceId
              }),
              ...(remoteName && {
                remoteName
              })
            }
          },
          signal
        });
        return response;
      } catch (error) {
        // ignore error for retrieving slos
      }
    },
    keepPreviousData: true,
    enabled: Boolean(sloId),
    refetchInterval: shouldRefetch ? _constants.SLO_LONG_REFETCH_INTERVAL : undefined,
    refetchOnWindowFocus: false
  });
  return {
    data,
    isLoading,
    isInitialLoading,
    isRefetching,
    isSuccess,
    isError,
    refetch
  };
}