"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorRateChart = ErrorRateChart;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../../hooks/use_kibana");
var _get_delay_in_seconds_from_slo = require("../../../utils/slo/get_delay_in_seconds_from_slo");
var _use_lens_definition = require("./use_lens_definition");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/components/slo/error_rate_chart/error_rate_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ErrorRateChart({
  slo,
  dataTimeRange,
  threshold,
  alertTimeRange,
  annotations,
  onBrushed,
  variant = 'success'
}) {
  const {
    lens: {
      EmbeddableComponent
    }
  } = (0, _use_kibana.useKibana)().services;
  const lensDef = (0, _use_lens_definition.useLensDefinition)({
    slo,
    threshold,
    alertTimeRange,
    dataTimeRange,
    annotations,
    variant
  });
  const delayInSeconds = (0, _get_delay_in_seconds_from_slo.getDelayInSecondsFromSLO)(slo);
  const from = (0, _moment.default)(dataTimeRange.from).subtract(delayInSeconds, 'seconds').toISOString();
  const to = (0, _moment.default)(dataTimeRange.to).subtract(delayInSeconds, 'seconds').toISOString();
  return /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
    id: "sloErrorRateChart",
    style: {
      height: 190
    },
    timeRange: {
      from,
      to
    },
    attributes: lensDef,
    viewMode: 'view',
    onBrushEnd: ({
      range
    }) => {
      onBrushed === null || onBrushed === void 0 ? void 0 : onBrushed({
        from: (0, _moment.default)(range[0]).toDate(),
        to: (0, _moment.default)(range[1]).toDate()
      });
    },
    noPadding: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  });
}