"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionViewSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/session_view/public/components/session_view_search_bar/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const translatePlaceholder = {
  placeholder: _i18n.i18n.translate('xpack.sessionView.searchBar.searchBarKeyPlaceholder', {
    defaultMessage: 'Find...'
  })
};
const NO_RESULTS = _i18n.i18n.translate('xpack.sessionView.searchBar.searchBarNoResults', {
  defaultMessage: 'No results'
});

/**
 * The main wrapper component for the session view.
 */
const SessionViewSearchBar = ({
  searchQuery,
  setSearchQuery,
  totalMatches,
  onPrevious,
  onNext,
  trackEvent
}) => {
  const showPagination = !!searchQuery && totalMatches !== 0;
  const noResults = !!searchQuery && totalMatches === 0;
  const styles = (0, _styles.useStyles)({
    hasSearchResults: showPagination
  });
  const [selectedResult, setSelectedResult] = (0, _react.useState)(0);
  const onSearch = (0, _react.useCallback)(({
    query
  }) => {
    setSelectedResult(0);
    if (query) {
      setSearchQuery(query.text);
    } else {
      setSearchQuery('');
    }
    if (trackEvent) {
      trackEvent('search_performed');
    }
  }, [setSearchQuery, trackEvent]);
  const onPageClick = (0, _react.useCallback)(page => {
    setSelectedResult(page);
    const isNext = page > selectedResult;
    if (isNext) {
      onNext(page);
    } else {
      onPrevious(page);
    }
    if (trackEvent) {
      trackEvent(isNext ? 'search_next' : 'search_previous');
    }
  }, [onNext, onPrevious, selectedResult, trackEvent]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "sessionView:searchBar",
    css: styles.searchBar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    query: searchQuery,
    onChange: onSearch,
    box: translatePlaceholder,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }), noResults && /*#__PURE__*/_react.default.createElement("span", {
    css: styles.noResults,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 21
    }
  }, NO_RESULTS), showPagination && /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "data-test-subj": "sessionView:searchPagination",
    "aria-label": _i18n.i18n.translate('xpack.sessionView.searchBar.pagination.ariaLabel', {
      defaultMessage: 'Search results pagination'
    }),
    css: styles.pagination,
    pageCount: totalMatches,
    activePage: selectedResult,
    onPageClick: onPageClick,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }));
};
exports.SessionViewSearchBar = SessionViewSearchBar;