"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanelAlertGroupItem = exports.ALERT_GROUP_ITEM_TITLE_TEST_ID = exports.ALERT_GROUP_ITEM_TEST_ID = exports.ALERT_GROUP_ITEM_COUNT_TEST_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _data_or_dash = require("../../utils/data_or_dash");
var _styles = require("../detail_panel_alert_list_item/styles");
var _detail_panel_alert_list_item = require("../detail_panel_alert_list_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/session_view/public/components/detail_panel_alert_group_item/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ALERT_GROUP_ITEM_TEST_ID = exports.ALERT_GROUP_ITEM_TEST_ID = 'sessionView:detailPanelAlertGroupItem';
const ALERT_GROUP_ITEM_COUNT_TEST_ID = exports.ALERT_GROUP_ITEM_COUNT_TEST_ID = 'sessionView:detailPanelAlertGroupCount';
const ALERT_GROUP_ITEM_TITLE_TEST_ID = exports.ALERT_GROUP_ITEM_TITLE_TEST_ID = 'sessionView:detailPanelAlertGroupTitle';
/**
 * Detail panel description list item.
 */
const DetailPanelAlertGroupItem = ({
  alerts,
  onJumpToEvent,
  onShowAlertDetails
}) => {
  var _alerts$0$kibana$aler, _alerts$, _alerts$$kibana, _rule$uuid;
  const styles = (0, _styles.useStyles)();
  const alertsCount = alerts.length.toLocaleString();
  if (!alerts[0].kibana) {
    return null;
  }
  const {
    rule
  } = (_alerts$0$kibana$aler = (_alerts$ = alerts[0]) === null || _alerts$ === void 0 ? void 0 : (_alerts$$kibana = _alerts$.kibana) === null || _alerts$$kibana === void 0 ? void 0 : _alerts$$kibana.alert) !== null && _alerts$0$kibana$aler !== void 0 ? _alerts$0$kibana$aler : {};
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: (_rule$uuid = rule === null || rule === void 0 ? void 0 : rule.uuid) !== null && _rule$uuid !== void 0 ? _rule$uuid : '',
    "data-test-subj": ALERT_GROUP_ITEM_TEST_ID,
    arrowDisplay: "right",
    initialIsOpen: false,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": ALERT_GROUP_ITEM_TITLE_TEST_ID,
      css: styles.alertTitleContainer,
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      css: styles.alertTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "danger",
      type: "warning",
      css: styles.alertIcon,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 13
      }
    }), (0, _data_or_dash.dataOrDash)(rule === null || rule === void 0 ? void 0 : rule.name))),
    css: styles.alertGroupItem,
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      "data-test-subj": ALERT_GROUP_ITEM_COUNT_TEST_ID,
      className: "eui-alignCenter",
      size: "m",
      css: styles.alertCountArrowPad,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, alertsCount),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, alerts.map(event => {
    var _event$kibana, _event$kibana$alert;
    const key = 'minimal_' + ((_event$kibana = event.kibana) === null || _event$kibana === void 0 ? void 0 : (_event$kibana$alert = _event$kibana.alert) === null || _event$kibana$alert === void 0 ? void 0 : _event$kibana$alert.uuid);
    return /*#__PURE__*/_react.default.createElement(_detail_panel_alert_list_item.DetailPanelAlertListItem, {
      key: key,
      minimal: true,
      event: event,
      onJumpToEvent: onJumpToEvent,
      onShowAlertDetails: onShowAlertDetails,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    });
  }));
};
exports.DetailPanelAlertGroupItem = DetailPanelAlertGroupItem;