"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerIngestPipelineRoutes = void 0;
var _error_handler = require("../utils/error_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerIngestPipelineRoutes = ({
  logger,
  router
}) => {
  router.get({
    path: '/internal/serverless_search/ingest_pipelines',
    validate: {},
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the es client'
      }
    }
  }, (0, _error_handler.errorHandler)(logger)(async (context, request, response) => {
    const {
      client
    } = (await context.core).elasticsearch;
    const privileges = await client.asCurrentUser.security.hasPrivileges({
      cluster: ['manage_pipeline']
    });
    const canManagePipelines = privileges === null || privileges === void 0 ? void 0 : privileges.cluster.manage_pipeline;
    if (!canManagePipelines) {
      return response.ok({
        body: {
          pipelines: {},
          canManagePipelines: false
        }
      });
    }
    const pipelines = await client.asCurrentUser.ingest.getPipeline();
    return response.ok({
      body: {
        pipelines,
        canManagePipelines
      },
      headers: {
        'content-type': 'application/json'
      }
    });
  }));
};
exports.registerIngestPipelineRoutes = registerIngestPipelineRoutes;