"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditServiceType = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@kbn/react-query");
var _react2 = require("@emotion/react");
var _i18n_string = require("../../../../common/i18n_string");
var _use_kibana = require("../../hooks/use_kibana");
var _use_connector_types = require("../../hooks/api/use_connector_types");
var _use_connector = require("../../hooks/api/use_connector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/serverless_search/public/application/components/connectors/edit_service_type.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditServiceType = ({
  connector,
  isDisabled
}) => {
  var _connectorTypes$find$, _connectorTypes$find;
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const connectorTypes = (0, _use_connector_types.useConnectorTypes)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    queryKey
  } = (0, _use_connector.useConnector)(connector.id);
  const allConnectors = (0, _react.useMemo)(() => connectorTypes.sort((a, b) => a.name.localeCompare(b.name)), [connectorTypes]);
  const {
    isLoading,
    mutate
  } = (0, _reactQuery.useMutation)({
    mutationFn: async inputServiceType => {
      if (inputServiceType === null || inputServiceType === '') {
        return {
          serviceType: inputServiceType,
          name: connector.name
        };
      }
      const body = {
        service_type: inputServiceType
      };
      await http.post(`/internal/serverless_search/connectors/${connector.id}/service_type`, {
        body: JSON.stringify(body)
      });

      // if name is empty, auto generate it and a similar index name
      const results = await http.post(`/internal/serverless_search/connectors/${connector.id}/generate_name`, {
        body: JSON.stringify({
          name: connector.name,
          is_native: connector.is_native,
          service_type: inputServiceType
        })
      });
      const connectorName = results.result.connectorName;
      const indexName = results.result.indexName;

      // save the generated connector name
      await http.post(`/internal/serverless_search/connectors/${connector.id}/name`, {
        body: JSON.stringify({
          name: connectorName || ''
        })
      });

      // save the generated index name (this does not create an index)
      try {
        // this can fail if another connector has an identical index_name value despite no index being created yet.
        // in this case we just won't update the index_name, the user can do that manually when they reach that step.
        await http.post(`/internal/serverless_search/connectors/${connector.id}/index_name`, {
          body: JSON.stringify({
            index_name: indexName
          })
        });
      } catch {
        // do nothing
      }
      return {
        serviceType: inputServiceType,
        name: connectorName
      };
    },
    onSuccess: successData => {
      queryClient.setQueryData(queryKey, {
        connector: {
          ...connector,
          service_type: successData.serviceType,
          name: successData.name
        }
      });
      queryClient.invalidateQueries(queryKey);
    }
  });
  const getInitialOptions = () => {
    return allConnectors.map((conn, key) => {
      const _icon = [];
      let _ariaLabelAppend = '';
      if (conn.isTechPreview) {
        _icon.push(/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          "aria-label": _i18n_string.TECH_PREVIEW_LABEL,
          key: key + '-preview',
          iconType: "beaker",
          color: "hollow",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 121,
            columnNumber: 11
          }
        }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.chooseConnectorSelectable.thechPreviewBadgeLabel', {
          defaultMessage: 'Tech preview'
        })));
        _ariaLabelAppend += ` ${_i18n_string.TECH_PREVIEW_LABEL}`;
      }
      if (conn.isBeta) {
        _icon.push(/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          "aria-label": _i18n_string.BETA_LABEL,
          key: key + '-beta',
          iconType: 'beta',
          color: "hollow",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 137,
            columnNumber: 11
          }
        }, _i18n_string.BETA_LABEL));
        _ariaLabelAppend += ` ${_i18n_string.BETA_LABEL}`;
      }
      return {
        key: key.toString(),
        label: conn.name,
        value: {
          _icon,
          _badges: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            size: "l",
            type: conn.iconPath,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 148,
              columnNumber: 20
            }
          }),
          serviceType: conn.serviceType
        },
        'aria-label': conn.name + _ariaLabelAppend
      };
    });
  };
  const initialOptions = getInitialOptions();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const renderOption = (option, searchValue, contentClassName) => {
    const {
      value: {
        _icon,
        _badges,
        serviceType
      } = {
        _icon: [],
        _badges: null,
        serviceType: ''
      },
      key,
      label
    } = option;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      className: contentClassName,
      key: key + '-span',
      gutterSize: "m",
      responsive: false,
      direction: "row",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 9
      }
    }, _badges), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: (0, _react2.css)`
            overflow: auto;
          `,
      grow: true,
      "data-test-subj": `serverlessSearchConnectorServiceType-${serviceType}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: "left",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
      text: label,
      truncation: "end",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 11
      }
    }, _icon)));
  };
  const onSelectedOptionChange = (0, _react.useCallback)(selectedItem => {
    if (selectedItem.length === 0) {
      return;
    }
    const keySelected = Number(selectedItem[0].key);
    mutate(allConnectors[keySelected].serviceType);
  }, [mutate, allConnectors]);
  const selectedOptions = (0, _react.useMemo)(() => {
    const selectedOption = initialOptions.find(option => {
      var _option$value;
      return ((_option$value = option.value) === null || _option$value === void 0 ? void 0 : _option$value.serviceType) === connector.service_type;
    });
    return selectedOption ? [selectedOption] : [];
  }, [initialOptions, connector.service_type]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.serverlessSearch.connectors.serviceTypeLabel', {
      defaultMessage: 'Connector type'
    }),
    "data-test-subj": "serverlessSearchEditConnectorType",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.serverlessSearch.connectors.chooseConnectorSelectable.euiComboBox.accessibleScreenReaderLabelLabel', {
      defaultMessage: 'Select a data source for your connector to use.'
    }),
    isDisabled: Boolean(connector.service_type) || isDisabled,
    isLoading: isLoading,
    "data-test-subj": "serverlessSearchEditConnectorTypeChoices",
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: connector.service_type ? (_connectorTypes$find$ = (_connectorTypes$find = connectorTypes.find(conn => conn.serviceType === connector.service_type)) === null || _connectorTypes$find === void 0 ? void 0 : _connectorTypes$find.iconPath) !== null && _connectorTypes$find$ !== void 0 ? _connectorTypes$find$ : '' : 'plugs',
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 11
      }
    }),
    singleSelection: {
      asPlainText: true
    },
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.serverlessSearch.connectors.chooseConnectorSelectable.placeholder.text', {
      defaultMessage: 'Choose a data source'
    }),
    options: initialOptions,
    selectedOptions: selectedOptions,
    onChange: onSelectedOptionChange,
    renderOption: renderOption,
    rowHeight: euiTheme.base / 2 * 5,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 7
    }
  }));
};
exports.EditServiceType = EditServiceType;