"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorIndexnamePanel = void 0;
var _eui = require("@elastic/eui");
var _reactQuery = require("@kbn/react-query");
var _react = _interopRequireWildcard(require("react"));
var _validate_index_name = require("../../../../utils/validate_index_name");
var _i18n_string = require("../../../../../common/i18n_string");
var _use_connector = require("../../../hooks/api/use_connector");
var _use_kibana = require("../../../hooks/use_kibana");
var _connector_index_name_form = require("./connector_index_name_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/serverless_search/public/application/components/connectors/connector_config/connector_index_name_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorIndexnamePanel = ({
  canManageConnectors,
  connector
}) => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const {
    data,
    isLoading,
    isSuccess,
    mutate,
    reset
  } = (0, _reactQuery.useMutation)({
    mutationFn: async inputName => {
      if (inputName && inputName !== connector.index_name) {
        const body = {
          index_name: inputName
        };
        await http.post(`/internal/serverless_search/connectors/${connector.id}/index_name`, {
          body: JSON.stringify(body)
        });
      }
      return inputName;
    }
  });
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    queryKey
  } = (0, _use_connector.useConnector)(connector.id);
  (0, _react.useEffect)(() => {
    if (isSuccess) {
      queryClient.setQueryData(queryKey, {
        connector: {
          ...connector,
          index_name: data
        }
      });
      queryClient.invalidateQueries(queryKey);
      reset();
    }
  }, [data, isSuccess, connector, queryClient, queryKey, reset]);
  const [newIndexName, setNewIndexName] = (0, _react.useState)(connector.index_name || '');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_connector_index_name_form.ConnectorIndexNameForm, {
    isDisabled: isLoading || !canManageConnectors,
    indexName: newIndexName,
    onChange: name => setNewIndexName(name),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchConnectorIndexnamePanelButton",
    color: "primary",
    disabled: !(0, _validate_index_name.isValidIndexName)(newIndexName),
    fill: true,
    isLoading: isLoading,
    onClick: () => mutate(newIndexName),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, _i18n_string.UPDATE_LABEL)))));
};
exports.ConnectorIndexnamePanel = ConnectorIndexnamePanel;