"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dsl = void 0;
var _dsl_queries = require("../../common/data/dsl_queries");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dsl = exports.dsl = {
  isInstalled() {
    return {
      exists: {
        field: 'elastic_rule.id'
      }
    };
  },
  isNotInstalled() {
    return {
      bool: {
        must_not: dsl.isInstalled()
      }
    };
  },
  isPrebuilt() {
    return {
      exists: {
        field: 'elastic_rule.prebuilt_rule_id'
      }
    };
  },
  isCustom() {
    return {
      bool: {
        must_not: dsl.isPrebuilt()
      }
    };
  },
  matchElasticTitle(title) {
    return {
      match: {
        'elastic_rule.title': title
      }
    };
  },
  matchOriginalTitle(title) {
    return {
      match: {
        'original_rule.title': title
      }
    };
  },
  matchTitle(title) {
    return {
      bool: {
        should: [
        // Match the translated title
        dsl.matchElasticTitle(title),
        // If translation failed, match the original title
        {
          bool: {
            must: [_dsl_queries.dsl.isFailed(), dsl.matchOriginalTitle(title)]
          }
        }]
      }
    };
  },
  isInstallable() {
    return {
      bool: {
        must: [_dsl_queries.dsl.isFullyTranslated(), dsl.isNotInstalled()]
      }
    };
  },
  isNotInstallable() {
    return {
      bool: {
        should: [_dsl_queries.dsl.isNotFullyTranslated(), dsl.isInstalled()]
      }
    };
  },
  isMissingIndex() {
    return {
      query_string: {
        query: `elastic_rule.query: "${_constants.MISSING_INDEX_PATTERN_PLACEHOLDER}"`
      }
    };
  }
};