"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getParseOriginalDashboardNode = void 0;
var _constants = require("../../../../../../../../common/siem_migrations/constants");
var _comments = require("../../../../../common/task/util/comments");
var _dashboard_xml = require("../../../../../../../../common/siem_migrations/parsers/splunk/dashboard_xml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getParseOriginalDashboardNode = () => {
  return async state => {
    if (state.original_dashboard.vendor !== 'splunk') {
      throw new Error('Unsupported dashboard vendor');
    }

    // Check if the XML content is supported
    const supportCheck = _dashboard_xml.SplunkXmlDashboardParser.isSupportedSplunkXml(state.original_dashboard.data);
    if (!supportCheck.isSupported) {
      return {
        parsed_original_dashboard: {
          title: state.original_dashboard.title,
          panels: []
        },
        translation_result: _constants.MigrationTranslationResult.UNTRANSLATABLE,
        comments: [(0, _comments.generateAssistantComment)(`Unsupported Splunk XML: ${supportCheck.reason}`)]
      };
    }
    const parser = new _dashboard_xml.SplunkXmlDashboardParser(state.original_dashboard.data);
    const panels = await parser.extractPanels();
    return {
      parsed_original_dashboard: {
        title: state.original_dashboard.title,
        panels
      }
    };
  };
};
exports.getParseOriginalDashboardNode = getParseOriginalDashboardNode;