"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardMigrationAgent = getDashboardMigrationAgent;
var _langgraph = require("@langchain/langgraph");
var _state = require("./state");
var _parse_original_dashboard = require("./nodes/parse_original_dashboard");
var _create_descriptions = require("./nodes/create_descriptions");
var _translate_panel = require("./nodes/translate_panel/translate_panel");
var _aggregate_dashboard = require("./nodes/aggregate_dashboard");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDashboardMigrationAgent(params) {
  const parseOriginalDashboardNode = (0, _parse_original_dashboard.getParseOriginalDashboardNode)();
  const createDescriptionsNode = (0, _create_descriptions.getCreateDescriptionsNode)(params);
  const translatePanel = (0, _translate_panel.getTranslatePanelNode)(params);
  const aggregateDashboardNode = (0, _aggregate_dashboard.getAggregateDashboardNode)();
  const siemMigrationAgentGraph = new _langgraph.StateGraph(_state.migrateDashboardState, _state.migrateDashboardConfigSchema)
  // Nodes
  .addNode('parseOriginalDashboard', parseOriginalDashboardNode).addNode('createDescriptions', createDescriptionsNode, {
    retryPolicy: _constants.RETRY_POLICY
  }).addNode('translatePanel', translatePanel.node, {
    subgraphs: [translatePanel.subgraph]
  }).addNode('aggregateDashboard', aggregateDashboardNode)
  // Edges
  .addEdge(_langgraph.START, 'parseOriginalDashboard').addConditionalEdges('parseOriginalDashboard', parsedDashboardRouter, ['createDescriptions', 'aggregateDashboard']).addConditionalEdges('createDescriptions', translatePanel.conditionalEdge, ['translatePanel']).addEdge('translatePanel', 'aggregateDashboard').addEdge('aggregateDashboard', _langgraph.END);
  const graph = siemMigrationAgentGraph.compile();
  graph.name = 'Dashboard Migration Graph'; // Customizes the name displayed in LangSmith
  return graph;
}

// Routers
const parsedDashboardRouter = state => {
  var _state$parsed_origina;
  return (_state$parsed_origina = state.parsed_original_dashboard.panels) !== null && _state$parsed_origina !== void 0 && _state$parsed_origina.length ? 'createDescriptions' : 'aggregateDashboard';
};