"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiemMigrationsDataClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SiemMigrationsDataClient {
  constructor(esScopedClient, logger) {
    // Data clients use the ES client `asInternalUser` by default.
    // We may want to use `asCurrentUser` instead in the future if the APIs are made public.
    (0, _defineProperty2.default)(this, "esClient", void 0);
    this.esScopedClient = esScopedClient;
    this.logger = logger;
    this.esClient = esScopedClient.asInternalUser;
  }

  /** Deletes a migration and all its associated items and resources. */
  async deleteMigration(migrationId) {
    const [migrationDeleteOperations, migrationItemsDeleteOperations, migrationResourcesDeleteOperations] = await Promise.all([this.migrations.prepareDelete(migrationId), this.items.prepareDelete(migrationId), this.resources.prepareDelete(migrationId)]);
    return this.esClient.bulk({
      refresh: 'wait_for',
      operations: [...migrationDeleteOperations, ...migrationItemsDeleteOperations, ...migrationResourcesDeleteOperations]
    }).then(() => {
      this.logger.info(`Deleted migration ${migrationId}`);
    }).catch(error => {
      this.logger.error(`Error deleting migration ${migrationId}: ${error}`);
      throw error;
    });
  }
}
exports.SiemMigrationsDataClient = SiemMigrationsDataClient;