"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hostEntityEngineDescription = exports.HOST_IDENTITY_FIELD = exports.HOST_DEFINITION_VERSION = void 0;
var _field_utils = require("./field_utils");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_DEFINITION_VERSION = exports.HOST_DEFINITION_VERSION = '1.0.0';
const HOST_IDENTITY_FIELD = exports.HOST_IDENTITY_FIELD = 'host.name';
const HOST_ENTITY_TYPE = 'Host';
const hostEntityEngineDescription = exports.hostEntityEngineDescription = {
  entityType: 'host',
  version: HOST_DEFINITION_VERSION,
  identityField: HOST_IDENTITY_FIELD,
  identityFieldMapping: {
    type: 'keyword'
  },
  settings: {
    timestampField: '@timestamp'
  },
  pipeline: [{
    set: {
      field: 'entity.type',
      value: HOST_ENTITY_TYPE,
      override: false
    }
  }],
  fields: [(0, _field_utils.collectValues)({
    source: 'host.domain'
  }), (0, _field_utils.collectValues)({
    source: 'host.hostname'
  }), (0, _field_utils.collectValues)({
    source: 'host.id'
  }), (0, _field_utils.collectValues)({
    source: 'host.os.name',
    mapping: {
      type: 'keyword',
      fields: {
        text: {
          type: 'match_only_text'
        }
      }
    }
  }), (0, _field_utils.collectValues)({
    source: 'host.os.type'
  }), (0, _field_utils.collectValues)({
    source: 'host.ip',
    mapping: {
      type: 'ip'
    }
  }), (0, _field_utils.collectValues)({
    source: 'host.mac'
  }), (0, _field_utils.collectValues)({
    source: 'host.type'
  }), (0, _field_utils.collectValues)({
    source: 'host.architecture'
  }), ...(0, _common.getCommonFieldDescriptions)('host'), ...(0, _common.getEntityFieldsDescriptions)('host'), (0, _field_utils.collectValues)({
    source: `host.entity.relationships.Communicates_with`,
    destination: 'entity.relationships.Communicates_with',
    mapping: {
      type: 'keyword'
    },
    allowAPIUpdate: true
  }), (0, _field_utils.collectValues)({
    source: `host.entity.relationships.Depends_on`,
    destination: 'entity.relationships.Depends_on',
    mapping: {
      type: 'keyword'
    },
    allowAPIUpdate: true
  }), (0, _field_utils.collectValues)({
    source: `host.entity.relationships.Dependent_of`,
    destination: 'entity.relationships.Dependent_of',
    mapping: {
      type: 'keyword'
    },
    allowAPIUpdate: true
  }), (0, _field_utils.collectValues)({
    source: `host.entity.relationships.Owned_by`,
    destination: 'entity.relationships.Owned_by',
    mapping: {
      type: 'keyword'
    },
    allowAPIUpdate: true
  }), (0, _field_utils.collectValues)({
    source: `host.entity.relationships.Accessed_frequently_by`,
    destination: 'entity.relationships.Accessed_frequently_by',
    mapping: {
      type: 'keyword'
    },
    allowAPIUpdate: true
  })]
};