"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.singleSearchAfter = void 0;
var _perf_hooks = require("perf_hooks");
var _utils = require("./utils");
var _with_security_span = require("../../../../utils/with_security_span");
var _logged_requests = require("./logged_requests");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// utilize search_after for paging results into bulk.
const singleSearchAfter = async ({
  searchRequest,
  services,
  ruleExecutionLogger,
  loggedRequestsConfig
}) => {
  return (0, _with_security_span.withSecuritySpan)('singleSearchAfter', async () => {
    const loggedRequests = [];
    try {
      var _nextSearchAfterResul;
      const start = _perf_hooks.performance.now();
      const nextSearchAfterResult = await services.scopedClusterClient.asCurrentUser.search(searchRequest);
      const end = _perf_hooks.performance.now();
      const searchErrors = (0, _utils.createErrorsFromShard)({
        errors: (_nextSearchAfterResul = nextSearchAfterResult._shards.failures) !== null && _nextSearchAfterResul !== void 0 ? _nextSearchAfterResul : []
      });
      if (loggedRequestsConfig) {
        loggedRequests.push({
          request: loggedRequestsConfig.skipRequestQuery ? undefined : (0, _logged_requests.logSearchRequest)(searchRequest),
          description: loggedRequestsConfig.description,
          request_type: loggedRequestsConfig.type,
          duration: Math.round(end - start)
        });
      }
      return {
        searchResult: nextSearchAfterResult,
        searchDuration: (0, _utils.makeFloatString)(end - start),
        searchErrors,
        loggedRequests
      };
    } catch (exc) {
      ruleExecutionLogger.error(`Searching events operation failed: ${exc}`);
      throw exc;
    }
  });
};
exports.singleSearchAfter = singleSearchAfter;