"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProviderBadge = void 0;
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../../common/api/timeline");
var _empty_value = require("../../../../common/components/empty_value");
var _provider_container = require("../../../../common/components/drag_and_drop/provider_container");
var _data_provider = require("./data_provider");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/data_providers/provider_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ProviderBadgeStyled = (0, _styledComponents.default)(_eui.EuiBadge)`
  .euiToolTipAnchor {
    &::after {
      font-style: normal;
      content: '|';
      padding: 0px 3px;
    }
  }

  &.globalFilterItem {
    white-space: nowrap;
    min-width: ${({
  $timelineType
}) => $timelineType === _timeline.TimelineTypeEnum.template ? '140px' : 'none'};
    display: flex;

    &.globalFilterItem-isDisabled {
      text-decoration: line-through;
      font-weight: 400;
      font-style: italic;
    }

    &.globalFilterItem-isError {
      box-shadow: 0 1px 1px -1px rgba(152, 162, 179, 0.2), 0 3px 2px -2px rgba(152, 162, 179, 0.2),
        inset 0 0 0 1px #bd271e;
    }
  }
`;
ProviderBadgeStyled.displayName = 'ProviderBadgeStyled';
const ProviderFieldBadge = _styledComponents.default.div`
  display: block;
  padding: ${({
  theme
}) => `${theme.eui.euiSizeXS} ${theme.eui.euiSizeS}`};
  font-size: 0.6em;
`;
const StyledTemplateFieldBadge = (0, _styledComponents.default)(ProviderFieldBadge)`
  background: ${({
  theme
}) => theme.eui.euiPanelBackgroundColorModifiers.accent};
  color: ${({
  theme
}) => theme.eui.euiColorAccentText};
  text-transform: uppercase;
`;
const ConvertFieldBadge = (0, _styledComponents.default)(ProviderFieldBadge)`
  background: ${({
  theme
}) => theme.eui.euiColorDarkShade};
  cursor: pointer;

  &:hover {
    text-decoration: underline;
  }
`;
const TemplateFieldBadgeComponent = ({
  type,
  toggleType
}) => {
  if (type !== _timeline.DataProviderTypeEnum.template) {
    return /*#__PURE__*/_react.default.createElement(ConvertFieldBadge, {
      onClick: toggleType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 7
      }
    }, i18n.CONVERT_TO_TEMPLATE_FIELD);
  }
  return /*#__PURE__*/_react.default.createElement(StyledTemplateFieldBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 10
    }
  }, i18n.TEMPLATE_FIELD_LABEL);
};
const TemplateFieldBadge = /*#__PURE__*/_react.default.memo(TemplateFieldBadgeComponent);
const closeButtonProps = {
  // Removing tab focus on close button because the same option can be obtained through the context menu
  // TODO: add a `DEL` keyboard press functionality
  tabIndex: -1
};
const ProviderBadge = exports.ProviderBadge = /*#__PURE__*/_react.default.memo(({
  deleteProvider,
  field,
  isEnabled,
  isExcluded,
  operator,
  providerId,
  togglePopover,
  toggleType,
  displayValue,
  val,
  type,
  timelineType
}) => {
  const deleteFilter = (0, _react.useCallback)(event => {
    // Make sure it doesn't also trigger the onclick for the whole badge
    if (event.stopPropagation) {
      event.stopPropagation();
    }
    deleteProvider();
  }, [deleteProvider]);
  const classes = (0, _react.useMemo)(() => (0, _classnames.default)('globalFilterItem', {
    'globalFilterItem-isDisabled': !isEnabled,
    'globalFilterItem-isExcluded': isExcluded
  }), [isEnabled, isExcluded]);
  const formattedValue = (0, _react.useMemo)(() => (0, _fp.isString)(val) && val === '' ? (0, _empty_value.getEmptyString)() : val, [val]);
  const prefix = (0, _react.useMemo)(() => isExcluded ? /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 48
    }
  }, i18n.NOT, " ") : null, [isExcluded]);
  const content = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, prefix, operator !== _data_provider.EXISTS_OPERATOR ? /*#__PURE__*/_react.default.createElement("span", {
    className: "field-value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }, `${field}: "${operator === 'includes' ? displayValue : formattedValue}"`) : /*#__PURE__*/_react.default.createElement("span", {
    className: "field-value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }, field, " ", i18n.EXISTS_LABEL)), [displayValue, field, formattedValue, operator, prefix]);
  const ariaLabel = (0, _react.useMemo)(() => i18n.SHOW_OPTIONS_DATA_PROVIDER({
    field,
    value: `${formattedValue}`
  }), [field, formattedValue]);
  return /*#__PURE__*/_react.default.createElement(_provider_container.ProviderContainer, {
    id: `${providerId}-${field}-${val}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ProviderBadgeStyled, {
    className: classes,
    color: "hollow",
    title: "",
    iconOnClick: deleteFilter,
    iconOnClickAriaLabel: i18n.REMOVE_DATA_PROVIDER,
    iconType: "cross",
    iconSide: "right",
    onClick: togglePopover,
    onClickAriaLabel: ariaLabel,
    closeButtonProps: closeButtonProps,
    "data-test-subj": "providerBadge",
    $timelineType: timelineType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }, content), timelineType === _timeline.TimelineTypeEnum.template && operator !== _data_provider.IS_ONE_OF_OPERATOR && /*#__PURE__*/_react.default.createElement(TemplateFieldBadge, {
    toggleType: toggleType,
    type: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 13
    }
  })));
});
ProviderBadge.displayName = 'ProviderBadge';