"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceName = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _search_strategy = require("../../../../../../common/search_strategy");
var _links = require("../../../../../common/components/links");
var _constants = require("../../../../../flyout/entity_details/shared/constants");
var _stateful_event_context = require("../../../../../common/components/events_viewer/stateful_event_context");
var _empty_value = require("../../../../../common/components/empty_value");
var _truncatable_text = require("../../../../../common/components/truncatable_text");
var _is_in_security_app = require("../../../../../common/hooks/is_in_security_app");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/service_name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ServiceNameComponent = ({
  Component,
  contextId,
  isButton,
  onClick,
  title,
  value
}) => {
  const eventContext = (0, _react.useContext)(_stateful_event_context.StatefulEventContext);
  const serviceName = `${value}`;
  const isInTimelineContext = serviceName && (eventContext === null || eventContext === void 0 ? void 0 : eventContext.timelineID);
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const isInSecurityApp = (0, _is_in_security_app.useIsInSecurityApp)();
  const openServiceDetailsSidePanel = (0, _react.useCallback)(e => {
    e.preventDefault();
    if (onClick) {
      onClick();
    }
    if (!eventContext || !isInTimelineContext) {
      return;
    }
    const {
      timelineID
    } = eventContext;
    openFlyout({
      right: {
        id: _constants.ServicePanelKey,
        params: {
          serviceName,
          contextID: contextId,
          scopeId: timelineID
        }
      }
    });
  }, [contextId, eventContext, isInTimelineContext, onClick, openFlyout, serviceName]);
  const content = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_links.EntityDetailsLink, {
    Component: Component,
    entityName: serviceName,
    isButton: isButton,
    onClick: isInTimelineContext || !isInSecurityApp ? openServiceDetailsSidePanel : undefined,
    title: title,
    entityType: _search_strategy.EntityType.service,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
    "data-test-subj": "draggable-truncatable-content",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, serviceName)), [serviceName, isButton, isInTimelineContext, openServiceDetailsSidePanel, Component, title, isInSecurityApp]);
  return (0, _fp.isString)(value) && serviceName.length > 0 ? content : (0, _empty_value.getEmptyTagValue)();
};
const ServiceName = exports.ServiceName = /*#__PURE__*/_react.default.memo(ServiceNameComponent);
ServiceName.displayName = 'ServiceName';