"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelinesTableColumns = exports.TimelinesTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("../translations"));
var _actions_columns = require("./actions_columns");
var _common_columns = require("./common_columns");
var _extended_columns = require("./extended_columns");
var _icon_header_columns = require("./icon_header_columns");
var _timeline = require("../../../../../common/api/timeline");
var _user_privileges = require("../../../../common/components/user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/open_timeline/timelines_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Returns the column definitions (passed as the `columns` prop to
 * `EuiBasicTable`) that are displayed in the compact `Open Timeline` modal
 * view, and the full view shown in the `All Timelines` view of the
 * `Timelines` page
 */

const getTimelinesTableColumns = ({
  actionTimelineToShow,
  deleteTimelines,
  enableExportTimelineDownloader,
  itemIdToExpandedNotesRowMap,
  onCreateRule,
  onCreateRuleFromEql,
  onOpenDeleteTimelineModal,
  onOpenTimeline,
  onToggleShowNotes,
  showExtendedColumns,
  timelineType,
  hasCrudAccess
}) => {
  return [...(0, _common_columns.getCommonColumns)({
    itemIdToExpandedNotesRowMap,
    onOpenTimeline,
    onToggleShowNotes,
    timelineType
  }), ...(0, _extended_columns.getExtendedColumns)(showExtendedColumns), ...(0, _icon_header_columns.getIconHeaderColumns)({
    timelineType
  }), ...(actionTimelineToShow.length ? (0, _actions_columns.getActionsColumns)({
    onCreateRule,
    onCreateRuleFromEql,
    actionTimelineToShow,
    deleteTimelines,
    enableExportTimelineDownloader,
    onOpenDeleteTimelineModal,
    onOpenTimeline,
    hasCrudAccess
  }) : [])];
};
exports.getTimelinesTableColumns = getTimelinesTableColumns;
/**
 * Renders a table that displays metadata about timelines, (i.e. name,
 * description, etc.)
 */
const TimelinesTable = exports.TimelinesTable = /*#__PURE__*/_react.default.memo(({
  actionTimelineToShow,
  deleteTimelines,
  defaultPageSize,
  loading: isLoading,
  itemIdToExpandedNotesRowMap,
  enableExportTimelineDownloader,
  onCreateRule,
  onCreateRuleFromEql,
  onOpenDeleteTimelineModal,
  onOpenTimeline,
  onSelectionChange,
  onTableChange,
  onToggleShowNotes,
  pageIndex,
  pageSize,
  searchResults,
  showExtendedColumns,
  sortField,
  sortDirection,
  tableRef,
  timelineType,
  totalSearchResultsCount
}) => {
  const pagination = (0, _react.useMemo)(() => {
    return {
      showPerPageOptions: showExtendedColumns,
      pageIndex,
      pageSize,
      pageSizeOptions: [Math.floor(Math.max(defaultPageSize, 1) / 2), defaultPageSize, defaultPageSize * 2],
      totalItemCount: totalSearchResultsCount
    };
  }, [defaultPageSize, pageIndex, pageSize, showExtendedColumns, totalSearchResultsCount]);
  const sorting = (0, _react.useMemo)(() => {
    return {
      sort: {
        field: sortField,
        direction: sortDirection
      }
    };
  }, [sortField, sortDirection]);
  const selection = (0, _react.useMemo)(() => {
    return {
      selectable: timelineResult => timelineResult.savedObjectId != null && timelineResult.status !== _timeline.TimelineStatusEnum.immutable,
      selectableMessage: selectable => !selectable ? i18n.MISSING_SAVED_OBJECT_ID : '',
      onSelectionChange
    };
  }, [onSelectionChange]);
  const {
    timelinePrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const columns = (0, _react.useMemo)(() => getTimelinesTableColumns({
    actionTimelineToShow,
    deleteTimelines,
    itemIdToExpandedNotesRowMap,
    enableExportTimelineDownloader,
    onCreateRule,
    onCreateRuleFromEql,
    onOpenDeleteTimelineModal,
    onOpenTimeline,
    onSelectionChange,
    onToggleShowNotes,
    showExtendedColumns,
    timelineType,
    hasCrudAccess: timelinePrivileges.crud
  }), [actionTimelineToShow, deleteTimelines, itemIdToExpandedNotesRowMap, enableExportTimelineDownloader, onCreateRule, onCreateRuleFromEql, onOpenDeleteTimelineModal, onOpenTimeline, onSelectionChange, onToggleShowNotes, showExtendedColumns, timelineType, timelinePrivileges]);
  const noItemsMessage = isLoading || searchResults == null ? i18n.LOADING : timelineType === _timeline.TimelineTypeEnum.template ? i18n.ZERO_TIMELINE_TEMPLATES_MATCH : i18n.ZERO_TIMELINES_MATCH;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    "data-test-subj": "timelines-table",
    itemId: "savedObjectId",
    itemIdToExpandedRowMap: itemIdToExpandedNotesRowMap,
    items: searchResults !== null && searchResults !== void 0 ? searchResults : [],
    loading: isLoading,
    noItemsMessage: noItemsMessage,
    onChange: onTableChange,
    pagination: pagination,
    selection: actionTimelineToShow.includes('selectable') ? selection : undefined,
    sorting: sorting,
    css: (0, _react2.css)`
          .euiTableCellContent {
            animation: none; /* Prevents applying max-height from animation */
          }

          .euiTableRow-isExpandedRow .euiTableCellContent__text {
            width: 100%; /* Fixes collapsing nested flex content in IE11 */
          }
        `,
    ref: tableRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 7
    }
  });
});
TimelinesTable.displayName = 'TimelinesTable';