"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EVENT_DURATION_FIELD_NAME = exports.Duration = void 0;
var _react = _interopRequireDefault(require("react"));
var _formatted_duration = require("../formatted_duration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/duration/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EVENT_DURATION_FIELD_NAME = exports.EVENT_DURATION_FIELD_NAME = 'event.duration';

/**
 * Renders draggable text containing the value of a field representing a
 * duration of time, (e.g. `event.duration`)
 */
const Duration = exports.Duration = /*#__PURE__*/_react.default.memo(({
  fieldName,
  value
}) => /*#__PURE__*/_react.default.createElement(_formatted_duration.FormattedDuration, {
  maybeDurationNanoseconds: value,
  tooltipTitle: fieldName,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 21,
    columnNumber: 3
  }
}));
Duration.displayName = 'Duration';