"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScreenReaderAnnouncementsProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_screen_reader_context = require("../hooks/use_screen_reader_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/containers/screen_reader_a11y.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Provider component that manages a11y screen reader announcements via context.
 */
const ScreenReaderAnnouncementsProvider = ({
  children
}) => {
  const [screenReaderMessage, setScreenReaderMessage] = (0, _react.useState)('');
  const announce = (0, _react.useCallback)(message => {
    setScreenReaderMessage(message);
  }, []);
  const contextValue = (0, _react.useMemo)(() => ({
    announce
  }), [announce]);
  return /*#__PURE__*/_react.default.createElement(_use_screen_reader_context.ScreenReaderAnnouncementsContext.Provider, {
    value: contextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderLive, {
    "aria-live": "assertive",
    "aria-atomic": "true",
    focusRegionOnTextChange: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }, screenReaderMessage), children);
};
exports.ScreenReaderAnnouncementsProvider = ScreenReaderAnnouncementsProvider;