"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TLPBadge = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../../../constants/common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/common/tlp_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LEVEL_TO_COLOR = {
  red: 'danger',
  amber: 'warning',
  'amber+strict': 'warning',
  green: 'success',
  white: 'hollow',
  clear: 'hollow'
};
const TLPBadge = ({
  value
}) => {
  const normalizedValue = value === null || value === void 0 ? void 0 : value.toLowerCase().trim();
  const color = LEVEL_TO_COLOR[normalizedValue || ''];
  const displayValue = (0, _react.useMemo)(() => normalizedValue === null || normalizedValue === void 0 ? void 0 : normalizedValue.replaceAll(/\W/g, ' ').split(' ').map(_lodash.capitalize).join(' '), [normalizedValue]);
  if (!color) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _common.EMPTY_VALUE);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 10
    }
  }, displayValue);
};
exports.TLPBadge = TLPBadge;