"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateGetMigrationDashboards = exports.useGetMigrationDashboards = void 0;
var _reactQuery = require("@kbn/react-query");
var _shared = require("@kbn/openapi-common/shared");
var _react = require("react");
var _constants = require("../../../../common/siem_migrations/dashboards/constants");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("../api");
var _constants2 = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetMigrationDashboards = params => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    migrationId
  } = params;
  const SPECIFIC_MIGRATION_PATH = (0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_DASHBOARDS_PATH, {
    migration_id: migrationId
  });
  return (0, _reactQuery.useQuery)(['GET', SPECIFIC_MIGRATION_PATH, params], async ({
    signal
  }) => {
    const response = await (0, _api.getMigrationDashboards)({
      signal,
      ...params
    });
    return {
      migrationDashboards: response.data,
      total: response.total
    };
  }, {
    ..._constants2.DEFAULT_QUERY_OPTIONS,
    onError: error => {
      addError(error, {
        title: i18n.GET_MIGRATION_DASHBOARDS_FAILURE
      });
    },
    cacheTime: 2 * 1000
  });
};

/**
 * We should use this hook to invalidate the dashboard migrations cache. For
 * example, dashboard migrations mutations, like installing a dashboard, should lead to cache invalidation.
 *
 * @returns A dashboard migrations cache invalidation callback
 */
exports.useGetMigrationDashboards = useGetMigrationDashboards;
const useInvalidateGetMigrationDashboards = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(migrationId => {
    const SPECIFIC_MIGRATION_PATH = (0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_DASHBOARDS_PATH, {
      migration_id: migrationId
    });

    /**
     * Invalidate all queries that start with SPECIFIC_MIGRATION_PATH. This
     * includes the in-memory query cache and paged query cache.
     */
    queryClient.invalidateQueries(['GET', SPECIFIC_MIGRATION_PATH], {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateGetMigrationDashboards = useInvalidateGetMigrationDashboards;