"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardMigrationDataInputWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_is_open_state = require("../../../../common/hooks/use_is_open_state");
var _data_input_flyout = require("./data_input_flyout");
var _components = require("../../../common/components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/data_input_flyout/wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardMigrationDataInputWrapper = exports.DashboardMigrationDataInputWrapper = /*#__PURE__*/_react.default.memo(({
  children,
  onFlyoutClosed
}) => {
  const {
    isOpen: isFlyoutOpen,
    open: openFlyout,
    close: closeFlyout
  } = (0, _use_is_open_state.useIsOpenState)(false);
  const [flyoutMigrationStats, setFlyoutMigrationStats] = (0, _react.useState)();
  const closeFlyoutHandler = (0, _react.useCallback)(() => {
    closeFlyout();
    setFlyoutMigrationStats(undefined);
    onFlyoutClosed === null || onFlyoutClosed === void 0 ? void 0 : onFlyoutClosed();
  }, [closeFlyout, onFlyoutClosed]);
  const openFlyoutHandler = (0, _react.useCallback)(migrationStats => {
    setFlyoutMigrationStats(migrationStats);
    openFlyout();
  }, [openFlyout]);
  return /*#__PURE__*/_react.default.createElement(_components.MigrationDataInputContextProvider, {
    openFlyout: openFlyoutHandler,
    closeFlyout: closeFlyoutHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, children, isFlyoutOpen && /*#__PURE__*/_react.default.createElement(_data_input_flyout.DashboardMigrationDataInputFlyout, {
    onClose: closeFlyout,
    migrationStats: flyoutMigrationStats,
    setFlyoutMigrationStats: setFlyoutMigrationStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }));
});
DashboardMigrationDataInputWrapper.displayName = 'DashboardMigrationDataInputWrapper';