"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomCriblForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _api = require("../api/api");
var _translator = require("../../../../common/security_integrations/cribl/translator");
var _validator = require("./util/validator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/security_integrations/cribl/components/custom_cribl_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getDefaultRouteEntry = () => {
  return {
    dataId: '',
    datastream: ''
  };
};
const RouteEntryComponent = /*#__PURE__*/_react.default.memo(({
  index,
  routeEntries,
  datastreamOpts,
  onChangeCriblDataId,
  onChangeDatastream,
  onDeleteEntry
}) => {
  const routeEntry = routeEntries[index]; // the route entry for this row

  const options = datastreamOpts.map(o => ({
    label: o
  }));
  const selectedOption = options.filter(o => o.label === routeEntry.datastream);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Cribl _dataId field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: routeEntry.dataId,
    onChange: e => onChangeCriblDataId(index, e.currentTarget.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.securitySolution.securityIntegration.cribl.mapsTo', {
    defaultMessage: 'MAPS TO'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Datastream",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: "Select",
    singleSelection: true,
    options: options,
    selectedOptions: selectedOption,
    onChange: o => {
      if (o.length > 0) {
        onChangeDatastream(index, o[0].label);
      } else {
        onChangeDatastream(index, '');
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "trash",
    onClick: () => onDeleteEntry(index),
    isDisabled: routeEntries.length === 1,
    "aria-label": "entryDeleteButton",
    className: "itemEntryDeleteButton",
    "data-test-subj": "itemEntryDeleteButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }))));
});
const CustomCriblForm = exports.CustomCriblForm = /*#__PURE__*/(0, _react.memo)(({
  newPolicy,
  onChange,
  isEditPage
}) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const [missingReqPermissions, setMissingReqPermissions] = (0, _react.useState)();
  const [datastreamOpts, setDatastreamOpts] = (0, _react.useState)([]);
  const [initialPackagePolicy] = (0, _react.useState)(newPolicy);
  (0, _react.useEffect)(() => {
    const fetchData = async () => {
      if (!http) return;
      const {
        indexTemplates,
        permissionsError
      } = await (0, _api.getFleetManagedIndexTemplates)(http);
      setDatastreamOpts(indexTemplates);
      if (permissionsError) {
        setMissingReqPermissions(true);
      }
    };
    fetchData();
  }, [http]);
  const [routeEntries, setRouteEntries] = (0, _react.useState)([]);

  // Set route entries from initial state
  (0, _react.useEffect)(() => {
    if (isEditPage) {
      if (initialPackagePolicy) {
        const fromConfig = (0, _translator.getRouteEntriesFromPolicyConfig)(initialPackagePolicy.vars);
        if (fromConfig.length > 0) {
          setRouteEntries(fromConfig);
          return;
        }
      }
    }
    const defaultRouteEntries = [getDefaultRouteEntry()];
    setRouteEntries(defaultRouteEntries);
  }, [isEditPage, initialPackagePolicy]);
  const onChangeCriblDataId = (index, value) => {
    const newValues = [...routeEntries];
    newValues[index] = {
      ...routeEntries[index],
      dataId: value
    };
    setRouteEntries(newValues);
    updateCriblPolicy(newValues);
  };
  const onChangeDatastream = (index, value) => {
    const newValues = [...routeEntries];
    newValues[index] = {
      ...routeEntries[index],
      datastream: value
    };
    setRouteEntries(newValues);
    updateCriblPolicy(newValues);
  };
  const onAddEntry = () => {
    const newValues = [...routeEntries, getDefaultRouteEntry()];
    setRouteEntries(newValues);
    updateCriblPolicy(newValues);
  };
  const onDeleteEntry = index => {
    const newValues = routeEntries.filter((_, idx) => idx !== index);
    setRouteEntries(newValues);
    updateCriblPolicy(newValues);
  };
  const updateCriblPolicy = updatedRouteEntries => {
    const updatedPolicy = {
      ...newPolicy,
      vars: {
        route_entries: {
          value: (0, _translator.getPolicyConfigValueFromRouteEntries)(updatedRouteEntries)
        }
      }
    };

    // must have at least one filled in and all entries must have both filled in or neither
    const isValid = (0, _validator.hasAtLeastOneValidRouteEntry)(updatedRouteEntries) && (0, _validator.allRouteEntriesArePaired)(updatedRouteEntries);
    onChange({
      isValid,
      updatedPolicy
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, missingReqPermissions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('xpack.securitySolution.securityIntegration.cribl.missingPermissionsCalloutTitle', {
      defaultMessage: 'Be sure you have the necessary privileges'
    }),
    iconType: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.securityIntegration.cribl.missingPermissionsCalloutDescription",
    defaultMessage: "To configure this integration, you must have `manage_index_templates` privileges and `manage_pipeline` or `manage_ingest_pipelines` privileges.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.securityIntegration.cribl.mappingInstruction",
    defaultMessage: "Add mappings for your Cribl sources to a corresponding Elastic Fleet Integration datastream.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    "data-test-subj": "entriesContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 11
    }
  }, routeEntries.map((_, idx) => /*#__PURE__*/_react.default.createElement(RouteEntryComponent, {
    key: idx,
    index: idx,
    routeEntries: routeEntries,
    datastreamOpts: datastreamOpts,
    onChangeCriblDataId: onChangeCriblDataId,
    onChangeDatastream: onChangeDatastream,
    onDeleteEntry: onDeleteEntry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    size: "s",
    iconType: "plusInCircle",
    onClick: onAddEntry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.securityIntegration.cribl.addButton",
    defaultMessage: "Add",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 13
    }
  }))));
});
RouteEntryComponent.displayName = 'CriblRouteEntry';
CustomCriblForm.displayName = 'CriblForm';