"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userRequestedAdditionalRelatedEvents = exports.userReloadedResolverNode = exports.userOverrodeSourcererSelection = exports.userOverrodeDateRange = exports.serverReturnedResolverData = exports.serverReturnedNodeEventsInCategory = exports.serverReturnedNodeData = exports.serverReturnedCurrentRelatedEventData = exports.serverFailedToReturnResolverData = exports.serverFailedToReturnNodeEventsInCategory = exports.serverFailedToReturnNodeData = exports.serverFailedToReturnCurrentRelatedEventData = exports.appRequestingNodeData = exports.appRequestedResolverData = exports.appRequestedNodeEventsInCategory = exports.appRequestedCurrentRelatedEventData = exports.appAbortedResolverDataRequest = void 0;
var _typescriptFsa = _interopRequireDefault(require("typescript-fsa"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionCreator = (0, _typescriptFsa.default)('x-pack/security_solution/analyzer');
const serverReturnedResolverData = exports.serverReturnedResolverData = actionCreator('SERVER_RETURNED_RESOLVER_DATA');
const appRequestedNodeEventsInCategory = exports.appRequestedNodeEventsInCategory = actionCreator('APP_REQUESTED_NODE_EVENTS_IN_CATEGORY');
const appRequestedResolverData = exports.appRequestedResolverData = actionCreator('APP_REQUESTED_RESOLVER_DATA');
const userRequestedAdditionalRelatedEvents = exports.userRequestedAdditionalRelatedEvents = actionCreator('USER_REQUESTED_ADDITIONAL_RELATED_EVENTS');
const serverFailedToReturnNodeEventsInCategory = exports.serverFailedToReturnNodeEventsInCategory = actionCreator('SERVER_FAILED_TO_RETUEN_NODE_EVENTS_IN_CATEGORY');
const serverFailedToReturnResolverData = exports.serverFailedToReturnResolverData = actionCreator('SERVER_FAILED_TO_RETURN_RESOLVER_DATA');
const appAbortedResolverDataRequest = exports.appAbortedResolverDataRequest = actionCreator('APP_ABORTED_RESOLVER_DATA_REQUEST');
const serverReturnedNodeEventsInCategory = exports.serverReturnedNodeEventsInCategory = actionCreator('SERVER_RETURNED_NODE_EVENTS_IN_CATEGORY');

/**
 * When events are returned for a set of graph nodes. For Endpoint graphs the events returned are process lifecycle events.
 */
const serverReturnedNodeData = exports.serverReturnedNodeData = actionCreator('SERVER_RETURNED_NODE_DATA');

/**
 * When the middleware kicks off the request for node data to the server.
 */
const appRequestingNodeData = exports.appRequestingNodeData = actionCreator('APP_REQUESTING_NODE_DATA');

/**
 * When the user clicks on a node that was in an error state to reload the node data.
 */
const userReloadedResolverNode = exports.userReloadedResolverNode = actionCreator('USER_RELOADED_RESOLVER_NODE');
const userOverrodeDateRange = exports.userOverrodeDateRange = actionCreator('USER_OVERRODE_DATE_RANGE');
const userOverrodeSourcererSelection = exports.userOverrodeSourcererSelection = actionCreator('USER_OVERRODE_SOURCERER_SELECTION');

/**
 * When the server returns an error after the app requests node data for a set of nodes.
 */
const serverFailedToReturnNodeData = exports.serverFailedToReturnNodeData = actionCreator('SERVER_FAILED_TO_RETURN_NODE_DATA');
const appRequestedCurrentRelatedEventData = exports.appRequestedCurrentRelatedEventData = actionCreator('APP_REQUESTED_CURRENT_RELATED_EVENT_DATA');
const serverFailedToReturnCurrentRelatedEventData = exports.serverFailedToReturnCurrentRelatedEventData = actionCreator('SERVER_FAILED_TO_RETURN_CURRENT_RELATED_EVENT_DATA');
const serverReturnedCurrentRelatedEventData = exports.serverReturnedCurrentRelatedEventData = actionCreator('SERVER_RETURNED_CURRENT_RELATED_EVENT_DATA');