"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CostSavingsKeyInsight = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _public = require("@kbn/kibana-react-plugin/public");
var _inferenceCommon = require("@kbn/inference-common");
var _kibana = require("../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_license = require("../../../common/hooks/use_license");
var _use_assistant_availability = require("../../../assistant/use_assistant_availability");
var _use_find_cost_savings_prompts = require("../../hooks/use_find_cost_savings_prompts");
var _use_default_ai_connector_id = require("../../../common/hooks/use_default_ai_connector_id");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/cost_savings_key_insight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CostSavingsKeyInsight = ({
  isLoading,
  lensResponse
}) => {
  const {
    euiTheme: {
      size
    }
  } = (0, _eui.useEuiTheme)();
  const {
    http,
    notifications,
    inference
  } = (0, _kibana.useKibana)().services;
  const [insightResult, setInsightResult] = (0, _react.useState)('');
  const {
    defaultConnectorId
  } = (0, _use_default_ai_connector_id.useDefaultAIConnectorId)();
  const hasEnterpriseLicence = _use_license.licenseService.isEnterprise();
  const {
    hasAssistantPrivilege,
    isAssistantEnabled
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const prompts = (0, _use_find_cost_savings_prompts.useFindCostSavingsPrompts)({
    context: {
      isAssistantEnabled: hasEnterpriseLicence && (isAssistantEnabled !== null && isAssistantEnabled !== void 0 ? isAssistantEnabled : false) && (hasAssistantPrivilege !== null && hasAssistantPrivilege !== void 0 ? hasAssistantPrivilege : false),
      httpFetch: http.fetch,
      toasts: notifications.toasts
    }
  });
  const fetchInsight = (0, _react.useCallback)(async () => {
    if (lensResponse && defaultConnectorId && prompts !== null) {
      try {
        const prompt = getPrompt(JSON.stringify(lensResponse), prompts);
        const result = await inference.chatComplete({
          connectorId: defaultConnectorId,
          messages: [{
            role: _inferenceCommon.MessageRole.User,
            content: prompt
          }]
        });
        setInsightResult(result.content);
      } catch (error) {
        var _ref, _error$body$message, _error$body;
        setInsightResult(`${i18n.INSIGHTS_ERROR} ${(_ref = (_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message) !== null && _ref !== void 0 ? _ref : error.toString()}`);
      }
    }
  }, [defaultConnectorId, lensResponse, inference, prompts]);
  (0, _react.useEffect)(() => {
    fetchInsight();
  }, [fetchInsight]);
  (0, _react.useEffect)(() => {
    if (!lensResponse) setInsightResult('');
  }, [lensResponse]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "alertProcessingKeyInsightsContainer",
    css: (0, _react2.css)`
        background: linear-gradient(
          112deg,
          rgba(89, 159, 254, 0.08) 3.58%,
          rgba(240, 78, 152, 0.08) 98.48%
        );
        border-radius: ${size.s};
        padding: ${size.base};
        min-height: 200px;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    "data-test-subj": "alertProcessingKeyInsightsGreetingGroup",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoElastic",
    size: "m",
    "data-test-subj": "alertProcessingKeyInsightsLogo",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "alertProcessingKeyInsightsGreeting",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  }, i18n.KEY_INSIGHT)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }), insightResult && !isLoading ? /*#__PURE__*/_react.default.createElement(_public.Markdown, {
    markdown: insightResult,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    size: "s",
    isLoading: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  })));
};
exports.CostSavingsKeyInsight = CostSavingsKeyInsight;
const getPrompt = (result, prompts) => {
  const prompt = `${prompts.part1}

\`\`\`
${result}
\`\`\`

${prompts.part2}`;
  return prompt;
};