"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSelectorPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _securitySolutionConnectors = require("@kbn/security-solution-connectors");
var _helpers = require("@kbn/elastic-assistant/impl/connectorland/helpers");
var _kibana_react = require("../../../../../../common/lib/kibana/kibana_react");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/common/connectors/connector_selector_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorSelectorPanel = exports.ConnectorSelectorPanel = /*#__PURE__*/_react.default.memo(({
  connectors,
  selectedConnectorId,
  onConnectorSelected
}) => {
  const {
    triggersActionsUi: {
      actionTypeRegistry
    },
    settings
  } = (0, _kibana_react.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const selectedConnector = (0, _react.useMemo)(() => connectors.find(connector => connector.id === selectedConnectorId), [connectors, selectedConnectorId]);
  (0, _react.useEffect)(() => {
    if (selectedConnectorId || !connectors.length) {
      return;
    }
    const inferenceConnector = connectors.find(({
      actionTypeId
    }) => actionTypeId === '.inference');
    if (inferenceConnector) {
      onConnectorSelected(inferenceConnector);
    } else if (connectors.length === 1) {
      onConnectorSelected(connectors[0]);
    }
  }, [selectedConnectorId, connectors, onConnectorSelected]);
  const onConnectorSelectionChange = (0, _react.useCallback)(connectorId => {
    const connector = connectors.find(c => c.id === connectorId);
    if (connector) {
      onConnectorSelected(connector);
    }
  }, [connectors, onConnectorSelected]);
  const betaBadgeProps = (0, _react.useMemo)(() => {
    if (!selectedConnector || !(0, _helpers.isElasticManagedLlmConnector)(selectedConnector)) {
      return;
    }
    return {
      label: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "connectorSelectorPanelBetaBadge",
        css: (0, _react2.css)`
              font-size: ${euiTheme.size.s};
              font-weight: ${euiTheme.font.weight.bold};
              line-height: ${euiTheme.base * 1.25}px;
              vertical-align: top;
            `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 11
        }
      }, i18n.PRECONFIGURED_CONNECTOR_LABEL),
      title: i18n.PRECONFIGURED_CONNECTOR_LABEL,
      color: 'subdued',
      css: (0, _react2.css)`
          height: ${euiTheme.base * 1.25}px;
        `
    };
  }, [euiTheme, selectedConnector]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    css: (0, _react2.css)`
          height: 100%;
        `,
    hasBorder: true,
    betaBadgeProps: betaBadgeProps,
    titleElement: "p",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      direction: "column",
      gutterSize: selectedConnector ? 'xl' : 'l',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 15
      }
    }, i18n.SELECTED_PROVIDER)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      css: (0, _react2.css)`
                  height: ${euiTheme.size.xl};
                `,
      direction: "column",
      justifyContent: "center",
      responsive: false,
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 15
      }
    }, selectedConnector && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      color: "text",
      type: actionTypeRegistry.get(selectedConnector.actionTypeId).iconClass,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_securitySolutionConnectors.ConnectorSelector, {
      connectors: connectors,
      selectedId: selectedConnectorId,
      onChange: onConnectorSelectionChange,
      settings: settings,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 19
      }
    }))))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  });
});
ConnectorSelectorPanel.displayName = 'ConnectorSelectorPanel';