"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorsAuthz = void 0;
var _capabilities = require("../../../../../../common/lib/capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConnectorsAuthz = capabilities => {
  const checker = new _capabilities.CapabilitiesChecker(capabilities);
  return {
    canReadConnectors: checker.has('actions.show'),
    canExecuteConnectors: checker.has([['actions.show', 'actions.execute']]),
    canCreateConnectors: checker.has('actions.save')
  };
};
exports.getConnectorsAuthz = getConnectorsAuthz;