"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointExceptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _user_privileges = require("../../../../common/components/user_privileges");
var _kibana = require("../../../../common/lib/kibana");
var _artifact_list_page = require("../../../components/artifact_list_page");
var _endpoint_exceptions_form = require("./components/endpoint_exceptions_form");
var _api_client = require("../service/api_client");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_exceptions/view/endpoint_exceptions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ENDPOINT_EXCEPTIONS_PAGE_LABELS = {
  pageTitle: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.pageTitle', {
    defaultMessage: 'Endpoint exceptions'
  }),
  pageAboutInfo: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.pageAboutInfo', {
    defaultMessage: 'Endpoint exceptions prevent generating an alert by Defend integration on the host.'
  }),
  pageAddButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.pageAddButtonTitle', {
    defaultMessage: 'Add endpoint exception'
  }),
  getShowingCountLabel: total => _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.showingTotal', {
    defaultMessage: 'Showing {total} {total, plural, one {endpoint exception} other {endpoint exceptions}}',
    values: {
      total
    }
  }),
  cardActionEditLabel: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.cardActionEditLabel', {
    defaultMessage: 'Edit endpoint exception'
  }),
  cardActionDeleteLabel: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.cardActionDeleteLabel', {
    defaultMessage: 'Delete endpoint exception'
  }),
  flyoutCreateTitle: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.flyoutCreateTitle', {
    defaultMessage: 'Add endpoint exception'
  }),
  flyoutEditTitle: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.flyoutEditTitle', {
    defaultMessage: 'Edit endpoint exception'
  }),
  flyoutCreateSubmitButtonLabel: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.flyoutCreateSubmitButtonLabel', {
    defaultMessage: 'Add endpoint exception'
  }),
  flyoutCreateSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.flyoutCreateSubmitSuccess', {
    defaultMessage: '"{name}" has been added to your endpoint exceptions.',
    values: {
      name
    }
  }),
  flyoutEditSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.flyoutEditSubmitSuccess', {
    defaultMessage: '"{name}" has been updated.',
    values: {
      name
    }
  }),
  flyoutDowngradedLicenseDocsInfo: securitySolutionDocsLinks => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpointExceptions.flyoutDowngradedLicenseDocsInfo",
      defaultMessage: "For more information, see our ",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      href: `${securitySolutionDocsLinks.endpointArtifacts}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpointExceptions.flyoutDowngradedLicenseDocsLink",
      defaultMessage: "endpoint exceptions documentation.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 11
      }
    })));
  },
  deleteActionSuccess: itemName => _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.deleteSuccess', {
    defaultMessage: '"{itemName}" has been removed from endpoint exceptions.',
    values: {
      itemName
    }
  }),
  emptyStateTitleNoEntries: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.emptyStateTitleNoEntries', {
    defaultMessage: 'There are no endpoint exceptions to display.'
  }),
  emptyStateTitle: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.emptyStateTitle', {
    defaultMessage: 'Add your first endpoint exception entry'
  }),
  emptyStateInfo: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.emptyStateInfo', {
    defaultMessage: 'Endpoint exceptions prevent generating an alert by Defend integration on the host.'
  }),
  emptyStatePrimaryButtonLabel: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.emptyStatePrimaryButtonLabel', {
    defaultMessage: 'Add endpoint exception'
  }),
  searchPlaceholderInfo: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.searchPlaceholderInfo', {
    defaultMessage: 'Search on the fields below: name, description, value'
  })
};
const EndpointExceptions = exports.EndpointExceptions = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    canWriteEndpointExceptions
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const http = (0, _kibana.useHttp)();
  const endpointExceptionsApiClient = _api_client.EndpointExceptionsApiClient.getInstance(http);
  return /*#__PURE__*/_react.default.createElement(_artifact_list_page.ArtifactListPage, {
    apiClient: endpointExceptionsApiClient,
    ArtifactFormComponent: _endpoint_exceptions_form.EndpointExceptionsForm,
    labels: ENDPOINT_EXCEPTIONS_PAGE_LABELS,
    "data-test-subj": "endpointExceptionsPage",
    searchableFields: _constants.SEARCHABLE_FIELDS,
    flyoutSize: "l",
    allowCardCreateAction: canWriteEndpointExceptions,
    allowCardEditAction: canWriteEndpointExceptions,
    allowCardDeleteAction: canWriteEndpointExceptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 5
    }
  });
});
EndpointExceptions.displayName = 'EndpointExceptions';