"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsLogTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/endpoint/service/response_actions/constants");
var _constants2 = require("../../../../../common/constants");
var _link_to = require("../../../../common/components/link_to");
var _links = require("../../../../common/components/links");
var _formatted_date = require("../../../../common/components/formatted_date");
var _translations = require("../translations");
var _hooks = require("./hooks");
var _empty_value = require("../../../../common/components/empty_value");
var _response_action_status_badge = require("./response_action_status_badge");
var _action_log_expanded_tray = require("./action_log_expanded_tray");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _constants3 = require("../../../common/constants");
var _use_url_pagination = require("../../../hooks/use_url_pagination");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_response_actions_list/components/actions_log_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyValue = (0, _empty_value.getEmptyValue)();

// Truncated usernames
const StyledFacetButton = (0, _common.euiStyled)(_eui.EuiFacetButton).attrs({
  title: undefined
})`
  .euiText {
    margin-top: 0.38rem;
    overflow-y: visible !important;
  }
`;
const getResponseActionListTableColumns = ({
  getTestId,
  expandedRowMap,
  showHostNames,
  onClickCallback
}) => {
  const columns = [{
    field: 'startedAt',
    name: _translations.TABLE_COLUMN_NAMES.time,
    width: !showHostNames ? '21%' : '15%',
    truncateText: true,
    render: startedAt => {
      return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
        fieldName: _translations.TABLE_COLUMN_NAMES.time,
        value: startedAt,
        className: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'command',
    name: _translations.TABLE_COLUMN_NAMES.command,
    width: !showHostNames ? '21%' : '10%',
    truncateText: true,
    render: _command => {
      const command = _constants.RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP[_command];
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: command,
        anchorClassName: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        className: "eui-textTruncate eui-fullWidth",
        "data-test-subj": getTestId('column-command'),
        tabIndex: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 13
        }
      }, command));
    }
  }, {
    name: _translations.TABLE_COLUMN_NAMES.user,
    width: !showHostNames ? '21%' : '14%',
    truncateText: true,
    render: ({
      createdBy,
      ruleId
    }) => {
      if (createdBy === 'unknown' && ruleId) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: _translations.UX_MESSAGES.triggeredByRule,
          anchorClassName: "eui-textTruncate",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 112,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
          "data-test-subj": "ruleName",
          deepLinkId: _constants2.SecurityPageName.rules,
          path: (0, _link_to.getRuleDetailsUrl)(ruleId),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          className: "eui-textTruncate eui-fullWidth",
          "data-test-subj": getTestId('column-user-name'),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 118,
            columnNumber: 17
          }
        }, _translations.UX_MESSAGES.triggeredByRule)));
      }
      return /*#__PURE__*/_react.default.createElement(StyledFacetButton, {
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar
        // We've a EuiTooltip that shows for createdBy below,
        // Thus we don't need to add a title tooltip as well.
        , {
          "aria-hidden": true,
          title: "",
          name: createdBy,
          "data-test-subj": getTestId('column-user-avatar'),
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 15
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: createdBy,
        anchorClassName: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        className: "eui-textTruncate eui-fullWidth",
        "data-test-subj": getTestId('column-user-name'),
        tabIndex: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 15
        }
      }, createdBy)));
    }
  },
  // conditional hostnames column
  {
    field: 'hosts',
    name: _translations.TABLE_COLUMN_NAMES.hosts,
    width: '20%',
    truncateText: true,
    render: _hosts => {
      const hostnames = Object.entries(_hosts).reduce((acc, [agentId, {
        name: hostName
      }]) => {
        acc.push(hostName || `${agentId} (${_translations.UX_MESSAGES.unenrolled.host})`);
        return acc;
      }, []).join(', ');
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: hostnames,
        anchorClassName: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        className: "eui-textTruncate eui-fullWidth",
        "data-test-subj": getTestId('column-hostname'),
        tabIndex: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 13
        }
      }, hostnames));
    }
  }, {
    field: 'comment',
    name: _translations.TABLE_COLUMN_NAMES.comments,
    width: !showHostNames ? '21%' : '30%',
    truncateText: true,
    render: comment => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: comment,
        anchorClassName: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        className: "eui-textTruncate eui-fullWidth",
        "data-test-subj": getTestId('column-comments'),
        tabIndex: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 193,
          columnNumber: 13
        }
      }, comment !== null && comment !== void 0 ? comment : emptyValue));
    }
  }, {
    field: 'status',
    name: _translations.TABLE_COLUMN_NAMES.status,
    width: !showHostNames ? '15%' : '10%',
    render: _status => {
      const status = (0, _hooks.getActionStatus)(_status);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: status,
        anchorClassName: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_response_action_status_badge.ResponseActionStatusBadge, {
        color: _status === 'failed' ? 'danger' : _status === 'successful' ? 'success' : 'warning',
        "data-test-subj": getTestId('column-status'),
        status: status,
        tabIndex: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 214,
          columnNumber: 13
        }
      }));
    }
  }, {
    field: '',
    align: _eui.RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 11
      }
    }, _translations.UX_MESSAGES.screenReaderExpand)),
    render: actionListDataItem => {
      const actionId = actionListDataItem.id;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": getTestId('expand-button'),
        onClick: onClickCallback(actionListDataItem),
        "aria-label": expandedRowMap[actionId] ? _translations.ARIA_LABELS.collapse : _translations.ARIA_LABELS.expand,
        iconType: expandedRowMap[actionId] ? 'arrowUp' : 'arrowDown',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 239,
          columnNumber: 11
        }
      });
    }
  }];
  // filter out the `hosts` column
  // if showHostNames is FALSE
  if (!showHostNames) {
    return columns.filter(column => column.field !== 'hosts');
  }
  return columns;
};
const ActionsLogTable = exports.ActionsLogTable = /*#__PURE__*/(0, _react.memo)(({
  'data-test-subj': dataTestSubj,
  error,
  items,
  isFlyout,
  loading,
  onChange,
  onShowActionDetails,
  queryParams,
  showHostNames,
  totalItemCount
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    pagination: paginationFromUrlParams
  } = (0, _use_url_pagination.useUrlPagination)();
  const [expandedRowMap, setExpandedRowMap] = (0, _react.useState)({});
  const actionIdsWithOpenTrays = (0, _react.useMemo)(() =>
  // get the list of action ids from the query params for flyout view
  queryParams.withOutputs ? typeof queryParams.withOutputs === 'string' ? [queryParams.withOutputs] : queryParams.withOutputs : [], [queryParams.withOutputs]);
  const redoOpenTrays = (0, _react.useCallback)(() => {
    if (actionIdsWithOpenTrays.length && items.length) {
      const openDetails = actionIdsWithOpenTrays.reduce((idToRowMap, actionId) => {
        const actionItem = items.find(item => item.id === actionId);
        if (!actionItem) {
          idToRowMap[actionId] = /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
            size: "relative",
            lines: 8,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 308,
              columnNumber: 38
            }
          });
        } else {
          idToRowMap[actionId] = /*#__PURE__*/_react.default.createElement(_action_log_expanded_tray.ActionsLogExpandedTray, {
            action: actionItem,
            "data-test-subj": dataTestSubj,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 311,
              columnNumber: 17
            }
          });
        }
        return idToRowMap;
      }, {});
      setExpandedRowMap(openDetails);
    }
  }, [actionIdsWithOpenTrays, dataTestSubj, items]);

  // open trays that were open using URL params/ query params
  (0, _react.useEffect)(() => {
    redoOpenTrays();
  }, [redoOpenTrays]);
  const toggleDetails = (0, _react.useCallback)(action => {
    const expandedRowMapCopy = {
      ...expandedRowMap
    };
    if (expandedRowMapCopy[action.id]) {
      // close tray
      delete expandedRowMapCopy[action.id];
    } else {
      // assign the expanded tray content to the map
      // with action details
      expandedRowMapCopy[action.id] = /*#__PURE__*/_react.default.createElement(_action_log_expanded_tray.ActionsLogExpandedTray, {
        action: action,
        "data-test-subj": dataTestSubj,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 337,
          columnNumber: 13
        }
      });
    }
    onShowActionDetails(Object.keys(expandedRowMapCopy));
    setExpandedRowMap(expandedRowMapCopy);
  }, [expandedRowMap, onShowActionDetails, dataTestSubj]);

  // memoized callback for toggleDetails
  const onClickCallback = (0, _react.useCallback)(actionListDataItem => () => toggleDetails(actionListDataItem), [toggleDetails]);

  // table pagination
  const tablePagination = (0, _react.useMemo)(() => {
    return {
      pageIndex: isFlyout ? (queryParams.page || 1) - 1 : paginationFromUrlParams.page - 1,
      pageSize: isFlyout ? queryParams.pageSize || 10 : paginationFromUrlParams.pageSize,
      totalItemCount,
      pageSizeOptions: _constants3.MANAGEMENT_PAGE_SIZE_OPTIONS
    };
  }, [isFlyout, paginationFromUrlParams.page, paginationFromUrlParams.pageSize, queryParams.page, queryParams.pageSize, totalItemCount]);

  // compute record ranges
  const pagedResultsCount = (0, _react.useMemo)(() => {
    var _queryParams$page, _queryParams$pageSize;
    const page = (_queryParams$page = queryParams.page) !== null && _queryParams$page !== void 0 ? _queryParams$page : 1;
    const perPage = (_queryParams$pageSize = queryParams === null || queryParams === void 0 ? void 0 : queryParams.pageSize) !== null && _queryParams$pageSize !== void 0 ? _queryParams$pageSize : 10;
    const totalPages = Math.ceil(totalItemCount / perPage);
    const fromCount = perPage * page - perPage + 1;
    const toCount = page === totalPages || totalPages === 1 ? totalItemCount : fromCount + perPage - 1;
    return {
      fromCount,
      toCount
    };
  }, [queryParams.page, queryParams.pageSize, totalItemCount]);

  // create range label to display
  const recordRangeLabel = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "default",
    size: "xs",
    "data-test-subj": getTestId('endpointListTableTotal'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.responseActionsList.list.recordRange",
    defaultMessage: "Showing {range} of {total} {recordsLabel}",
    values: {
      range: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 391,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: pagedResultsCount.fromCount,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 392,
          columnNumber: 19
        }
      }), '-', /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: pagedResultsCount.toCount,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 394,
          columnNumber: 19
        }
      })),
      total: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: totalItemCount,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 397,
          columnNumber: 22
        }
      }),
      recordsLabel: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 398,
          columnNumber: 29
        }
      }, _translations.UX_MESSAGES.recordsLabel(totalItemCount))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 11
    }
  })), [getTestId, pagedResultsCount.fromCount, pagedResultsCount.toCount, totalItemCount]);
  const columns = (0, _react.useMemo)(() => getResponseActionListTableColumns({
    getTestId,
    expandedRowMap,
    onClickCallback,
    showHostNames
  }), [expandedRowMap, getTestId, onClickCallback, showHostNames]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, recordRangeLabel, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 420,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": dataTestSubj,
    items: items,
    columns: columns,
    itemId: "id",
    itemIdToExpandedRowMap: expandedRowMap,
    pagination: tablePagination,
    onChange: onChange,
    loading: loading,
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 9
    }
  }));
});
ActionsLogTable.displayName = 'ActionsLogTable';