"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadActionResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _endpoint_upload_action_result = require("../../endpoint_upload_action_result");
var _use_console_action_submitter = require("../hooks/use_console_action_submitter");
var _use_send_upload_endpoint_request = require("../../../hooks/response_actions/use_send_upload_endpoint_request");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_responder/command_render_components/upload_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UploadActionResult = exports.UploadActionResult = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStore,
  store,
  status,
  setStatus,
  ResultComponent
}) => {
  var _command$commandDefin3;
  const actionCreator = (0, _use_send_upload_endpoint_request.useSendUploadEndpointRequest)();
  const actionRequestBody = (0, _react.useMemo)(() => {
    var _command$commandDefin, _command$commandDefin2;
    const {
      agentType,
      endpointId
    } = (_command$commandDefin = (_command$commandDefin2 = command.commandDefinition) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2.meta) !== null && _command$commandDefin !== void 0 ? _command$commandDefin : {};
    const {
      comment,
      overwrite,
      file
    } = command.args.args;
    if (!endpointId) {
      return;
    }
    const reqBody = {
      agent_type: agentType,
      endpoint_ids: [endpointId],
      ...(comment !== null && comment !== void 0 && comment[0] ? {
        comment: comment === null || comment === void 0 ? void 0 : comment[0]
      } : {}),
      parameters: overwrite !== undefined ? {
        overwrite: overwrite === null || overwrite === void 0 ? void 0 : overwrite[0]
      } : {},
      file: file[0]
    };
    return reqBody;
  }, [command.args.args, (_command$commandDefin3 = command.commandDefinition) === null || _command$commandDefin3 === void 0 ? void 0 : _command$commandDefin3.meta]);
  const {
    result,
    actionDetails
  } = (0, _use_console_action_submitter.useConsoleActionSubmitter)({
    ResultComponent,
    setStore,
    store,
    status,
    setStatus,
    actionCreator,
    actionRequestBody,
    dataTestSubj: 'upload'
  });
  if (actionDetails !== null && actionDetails !== void 0 && actionDetails.isCompleted && actionDetails.wasSuccessful) {
    return /*#__PURE__*/_react.default.createElement(ResultComponent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_endpoint_upload_action_result.EndpointUploadActionResult, {
      action: actionDetails,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }));
  }
  return result;
});
UploadActionResult.displayName = 'UploadActionResult';