"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArtifactDeleteModal = exports.ARTIFACT_DELETE_LABELS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _autofocus_button = require("../../../../common/components/autofocus_button/autofocus_button");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _artifacts = require("../../../../../common/endpoint/service/artifacts");
var _use_with_artifact_delete_item = require("../hooks/use_with_artifact_delete_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/artifact_list_page/components/artifact_delete_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ARTIFACT_DELETE_LABELS = exports.ARTIFACT_DELETE_LABELS = Object.freeze({
  deleteModalTitle: itemName => _i18n.i18n.translate('xpack.securitySolution.artifactListPage.deleteModalTitle', {
    defaultMessage: 'Delete {itemName}',
    values: {
      itemName
    }
  }),
  deleteModalImpactTitle: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.deleteModalImpactTitle', {
    defaultMessage: 'Warning'
  }),
  deleteModalImpactInfo: item => {
    return _i18n.i18n.translate('xpack.securitySolution.artifactListPage.deleteModalImpactInfo', {
      defaultMessage: 'Deleting this entry will remove it from {count} associated {count, plural, one {policy} other {policies}}.',
      values: {
        count: (0, _artifacts.isArtifactGlobal)(item) ? _i18n.i18n.translate('xpack.securitySolution.artifactListPage.deleteModalImpactInfoAll', {
          defaultMessage: 'all'
        }) : (0, _artifacts.getPolicyIdsFromArtifact)(item).length
      }
    });
  },
  deleteModalConfirmInfo: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.deleteModalConfirmInfo', {
    defaultMessage: 'This action cannot be undone. Are you sure you wish to continue?'
  }),
  deleteModalSubmitButtonTitle: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.deleteModalSubmitButtonTitle', {
    defaultMessage: 'Delete'
  }),
  deleteModalCancelButtonTitle: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.deleteModalCancelButtonTitle', {
    defaultMessage: 'Cancel'
  })
});
const ArtifactDeleteModal = exports.ArtifactDeleteModal = /*#__PURE__*/(0, _react.memo)(({
  apiClient,
  item,
  onCancel,
  onSuccess,
  'data-test-subj': dataTestSubj,
  labels
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    deleteArtifactItem,
    isLoading: isDeleting
  } = (0, _use_with_artifact_delete_item.useWithArtifactDeleteItem)(apiClient, item, labels);
  const onConfirm = (0, _react.useCallback)(() => {
    deleteArtifactItem(item).then(() => onSuccess());
  }, [deleteArtifactItem, item, onSuccess]);
  const handleOnCancel = (0, _react.useCallback)(() => {
    if (!isDeleting) {
      onCancel();
    }
  }, [isDeleting, onCancel]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: handleOnCancel,
    "data-test-subj": dataTestSubj,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    "data-test-subj": getTestId('header'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, labels.deleteModalTitle(item.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    "data-test-subj": getTestId('body'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": getTestId('impactCallout'),
    title: labels.deleteModalImpactTitle,
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": getTestId('impactCalloutInfo'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }, labels.deleteModalImpactInfo(item))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }, labels.deleteModalConfirmInfo))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: handleOnCancel,
    isDisabled: isDeleting,
    "data-test-subj": getTestId('cancelButton'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, labels.deleteModalCancelButtonTitle), /*#__PURE__*/_react.default.createElement(_autofocus_button.AutoFocusButton, {
    fill: true,
    color: "danger",
    onClick: onConfirm,
    isLoading: isDeleting,
    isDisabled: isDeleting,
    "data-test-subj": getTestId('submitButton'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, labels.deleteModalSubmitButtonTitle)));
});
ArtifactDeleteModal.displayName = 'ArtifactDeleteModal';