"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArtifactCardGrid = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _artifact_entry_card = require("../artifact_entry_card");
var _paginated_content = require("../paginated_content");
var _grid_header = require("./components/grid_header");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/artifact_card_grid/artifact_card_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PaginatedContent = _paginated_content.PaginatedContent;
const ArtifactCardGrid = exports.ArtifactCardGrid = /*#__PURE__*/(0, _react.memo)(({
  items: _items,
  cardComponentProps,
  onPageChange,
  onExpandCollapse,
  'data-test-subj': dataTestSubj,
  ...paginatedContentProps
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const items = _items;

  // The list of card props that the caller can define

  const callerDefinedCardProps = (0, _react.useMemo)(() => {
    const cardProps = new Map();
    for (const artifact of items) {
      cardProps.set(artifact, cardComponentProps ? cardComponentProps(artifact) : {});
    }
    return cardProps;
  }, [cardComponentProps, items]);

  // Handling of what is expanded or collapsed is done by looking at the at what the caller card's
  // `expanded` prop value was and then invert it for the card that the user clicked expand/collapse
  const handleCardExpandCollapse = (0, _react.useCallback)(item => {
    const expanded = [];
    const collapsed = [];
    for (const [artifact, currentCardProps] of callerDefinedCardProps) {
      const currentExpandedState = Boolean(currentCardProps.expanded);
      const newExpandedState = artifact === item ? !currentExpandedState : currentExpandedState;
      if (newExpandedState) {
        expanded.push(artifact);
      } else {
        collapsed.push(artifact);
      }
    }
    onExpandCollapse({
      expanded,
      collapsed
    });
  }, [callerDefinedCardProps, onExpandCollapse]);
  const isEverythingExpanded = (0, _react.useMemo)(() => {
    for (const [_, currentCardProps] of callerDefinedCardProps) {
      const currentExpandedState = Boolean(currentCardProps.expanded);
      if (!currentExpandedState) {
        return false;
      }
    }
    return true;
  }, [callerDefinedCardProps]);
  const handleCardExpandCollapseAll = (0, _react.useCallback)(() => {
    let expanded = [];
    let collapsed = [];
    if (!isEverythingExpanded) {
      expanded = Array.from(callerDefinedCardProps.keys());
    } else {
      collapsed = Array.from(callerDefinedCardProps.keys());
    }
    onExpandCollapse({
      expanded,
      collapsed
    });
  }, [callerDefinedCardProps, onExpandCollapse, isEverythingExpanded]);

  // Full list of card props that includes the actual artifact and the callbacks

  const fullCardProps = (0, _react.useMemo)(() => {
    const newFullCardProps = new Map();
    for (const [artifact, cardProps] of callerDefinedCardProps) {
      var _cardProps$dataTest;
      newFullCardProps.set(artifact, {
        ...cardProps,
        item: artifact,
        onExpandCollapse: () => handleCardExpandCollapse(artifact),
        'data-test-subj': (_cardProps$dataTest = cardProps['data-test-subj']) !== null && _cardProps$dataTest !== void 0 ? _cardProps$dataTest : getTestId('card')
      });
    }
    return newFullCardProps;
  }, [callerDefinedCardProps, getTestId, handleCardExpandCollapse]);
  const handleItemComponentProps = (0, _react.useCallback)(item => {
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    return fullCardProps.get(item);
  }, [fullCardProps]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_grid_header.GridHeader, {
    expandAllIconType: isEverythingExpanded ? 'fold' : 'unfold',
    onExpandCollapseAll: handleCardExpandCollapseAll,
    "data-test-subj": getTestId('header'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(PaginatedContent, (0, _extends2.default)({}, paginatedContentProps, {
    "data-test-subj": dataTestSubj,
    items: items,
    ItemComponent: _artifact_entry_card.ArtifactEntryCollapsibleCard,
    itemComponentProps: handleItemComponentProps,
    onChange: onPageChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  })));
});
ArtifactCardGrid.displayName = 'ArtifactCardGrid';