"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelNavigation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _kibana = require("../../../common/lib/kibana");
var _header_actions = require("./components/header_actions");
var _flyout_navigation = require("../../shared/components/flyout_navigation");
var _panel_keys = require("../shared/constants/panel_keys");
var _context = require("../shared/context");
var _telemetry = require("../../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/navigation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PanelNavigation = exports.PanelNavigation = /*#__PURE__*/(0, _react.memo)(({
  flyoutIsExpandable
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    eventId,
    indexName,
    scopeId,
    isRulePreview
  } = (0, _context.useDocumentDetailsContext)();
  const expandDetails = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _panel_keys.DocumentDetailsLeftPanelKey,
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: scopeId,
      panel: 'left'
    });
  }, [eventId, openLeftPanel, indexName, scopeId, telemetry]);
  return /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
    flyoutIsExpandable: flyoutIsExpandable,
    expandDetails: expandDetails,
    actions: /*#__PURE__*/_react.default.createElement(_header_actions.HeaderActions, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 16
      }
    }),
    isPreviewMode: false,
    isRulePreview: isRulePreview,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  });
});
PanelNavigation.displayName = 'PanelNavigation';