"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RightPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _panel_keys = require("../shared/constants/panel_keys");
var _use_tabs = require("./hooks/use_tabs");
var _local_storage = require("../shared/constants/local_storage");
var _kibana = require("../../../common/lib/kibana");
var _context = require("../shared/context");
var _navigation = require("./navigation");
var _header = require("./header");
var _content = require("./content");
var _footer = require("./footer");
var _use_flyout_is_expandable = require("./hooks/use_flyout_is_expandable");
var _telemetry = require("../../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Panel to be displayed in the document details expandable flyout right section
 */
const RightPanel = exports.RightPanel = /*#__PURE__*/(0, _react.memo)(({
  path
}) => {
  const {
    storage,
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openRightPanel,
    closeFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    eventId,
    indexName,
    scopeId,
    isRulePreview,
    dataAsNestedObject,
    getFieldsData
  } = (0, _context.useDocumentDetailsContext)();

  // if the flyout is expandable we render all 3 tabs (overview, table and json)
  // if the flyout is not, we render only table and json
  const flyoutIsExpandable = (0, _use_flyout_is_expandable.useFlyoutIsExpandable)({
    getFieldsData,
    dataAsNestedObject
  });
  const {
    tabsDisplayed,
    selectedTabId
  } = (0, _use_tabs.useTabs)({
    flyoutIsExpandable,
    path
  });
  const setSelectedTabId = tabId => {
    openRightPanel({
      id: _panel_keys.DocumentDetailsRightPanelKey,
      path: {
        tab: tabId
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });

    // saving which tab is currently selected in the right panel in local storage
    storage.set(_local_storage.FLYOUT_STORAGE_KEYS.RIGHT_PANEL_SELECTED_TABS, tabId);
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutTabClicked, {
      location: scopeId,
      panel: 'right',
      tabId
    });
  };

  // If flyout is open in rule preview, do not reload with stale information
  (0, _react.useEffect)(() => {
    const beforeUnloadHandler = () => {
      if (isRulePreview) {
        closeFlyout();
      }
    };
    window.addEventListener('beforeunload', beforeUnloadHandler);
    return () => {
      window.removeEventListener('beforeunload', beforeUnloadHandler);
    };
  }, [isRulePreview, closeFlyout]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_navigation.PanelNavigation, {
    flyoutIsExpandable: flyoutIsExpandable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_header.PanelHeader, {
    tabs: tabsDisplayed,
    selectedTabId: selectedTabId,
    setSelectedTabId: setSelectedTabId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_content.PanelContent, {
    tabs: tabsDisplayed,
    selectedTabId: selectedTabId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_footer.PanelFooter, {
    isRulePreview: isRulePreview,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }));
});
RightPanel.displayName = 'RightPanel';