"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightedFieldsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _helpers = require("../../../../detection_engine/common/helpers");
var _form = require("../../../../detection_engine/rule_creation_ui/pages/form");
var _use_default_index_pattern = require("../../../../detection_engine/rule_management/hooks/use_default_index_pattern");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_update_rule = require("../../../../detection_engine/rule_management/logic/use_update_rule");
var _shared_imports = require("../../../../shared_imports");
var _use_highlighted_fields = require("../../shared/hooks/use_highlighted_fields");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/highlighted_fields_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SUCCESSFULLY_SAVED_RULE = ruleName => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.update.successfullySavedRuleTitle', {
  values: {
    ruleName
  },
  defaultMessage: '{ruleName} was saved'
});
const ADD_CUSTOM_FIELD_LABEL = _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.highlightedFields.modalAddCustomFieldLabel', {
  defaultMessage: 'Add custom'
});
const SELECT_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.highlightedFields.modalSelectPlaceholder', {
  defaultMessage: 'Select or search for options'
});
const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const schema = {
  customHighlightedFields: {
    fieldsToValidateOnChange: ['customHighlightedFields'],
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField('error')
    }]
  }
};
const formConfig = {
  ...schema.customHighlightedFields,
  label: ADD_CUSTOM_FIELD_LABEL
};
/**
 * Modal for editing the highlighted fields of a rule.
 */
const HighlightedFieldsModal = ({
  rule,
  customHighlightedFields,
  dataFormattedForFieldBrowser,
  setIsEditLoading,
  setIsModalVisible
}) => {
  const defaultIndexPattern = (0, _use_default_index_pattern.useDefaultIndexPattern)();
  const {
    dataSourceType,
    index,
    dataViewId
  } = (0, _react.useMemo)(() => (0, _helpers.getDefineStepsData)(rule), [rule]);
  const {
    indexPattern: dataView
  } = (0, _form.useRuleIndexPattern)({
    dataSourceType,
    index: index.length > 0 ? index : defaultIndexPattern,
    // fallback to default index pattern if rule has no index patterns
    dataViewId
  });
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    mutateAsync: updateRule
  } = (0, _use_update_rule.useUpdateRule)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const defaultFields = (0, _use_highlighted_fields.useHighlightedFields)({
    dataFormattedForFieldBrowser,
    investigationFields: customHighlightedFields,
    type: 'default'
  });
  const defaultFieldsArray = (0, _react.useMemo)(() => Object.keys(defaultFields), [defaultFields]);
  const options = (0, _react.useMemo)(() => {
    const allFields = dataView.fields;
    return allFields.filter(field => !defaultFieldsArray.includes(field.name)).map(field => ({
      label: field.name
    }));
  }, [dataView, defaultFieldsArray]);
  const customFields = (0, _react.useMemo)(() => customHighlightedFields.map(field => ({
    label: field
  })), [customHighlightedFields]);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)(customFields);
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: {
      customHighlightedFields: []
    },
    schema
  });
  const onCancel = (0, _react.useCallback)(() => {
    setIsModalVisible(false);
  }, [setIsModalVisible]);
  const onSubmit = (0, _react.useCallback)(async () => {
    var _updatedRule$name;
    setIsEditLoading(true);
    const updatedRule = await updateRule({
      ...rule,
      id: undefined,
      investigation_fields: selectedOptions.length > 0 ? {
        field_names: selectedOptions.map(option => option.label)
      } : undefined
    });
    addSuccess(SUCCESSFULLY_SAVED_RULE((_updatedRule$name = updatedRule === null || updatedRule === void 0 ? void 0 : updatedRule.name) !== null && _updatedRule$name !== void 0 ? _updatedRule$name : 'rule'));
    setIsEditLoading(false);
    setIsModalVisible(false);
  }, [updateRule, addSuccess, rule, setIsModalVisible, setIsEditLoading, selectedOptions]);
  const componentProps = (0, _react.useMemo)(() => ({
    idAria: 'customizeHighlightedFields',
    'data-test-subj': _test_ids.HIGHLIGHTED_FIELDS_MODAL_CUSTOM_FIELDS_TEST_ID,
    euiFieldProps: {
      fullWidth: true,
      noSuggestions: false,
      onChange: fields => setSelectedOptions(fields),
      options,
      placeholder: SELECT_PLACEHOLDER,
      selectedOptions
    }
  }), [options, selectedOptions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    css: {
      width: '600px'
    },
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_MODAL_TEST_ID,
    id: modalTitleId,
    onClose: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_MODAL_TITLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.highlightedFields.modalTitle",
    defaultMessage: "Edit highlighted fields",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_MODAL_DESCRIPTION_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.highlightedFields.modalDescription",
    defaultMessage: "Changes made here will be applied to the {ruleName} rule. Any custom fields you add will be displayed in all alerts generated by this rule.",
    values: {
      ruleName: /*#__PURE__*/_react.default.createElement("b", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 220,
          columnNumber: 33
        }
      }, rule.name)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    css: (0, _react2.css)`
            font-weight: ${euiTheme.font.weight.semiBold};
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.highlightedFields.modalDefaultFieldsTitle",
    defaultMessage: "Default",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_MODAL_DEFAULT_FIELDS_TEST_ID,
    gutterSize: "xs",
    justifyContent: "flexStart",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 9
    }
  }, defaultFieldsArray.map(field => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: field,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 15
    }
  }, field)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "customHighlightedFields",
    config: formConfig,
    componentProps: componentProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_MODAL_CANCEL_BUTTON_TEST_ID,
    flush: "left",
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.highlightedFields.modalCancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_MODAL_SAVE_BUTTON_TEST_ID,
    fill: true,
    onClick: onSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.highlightedFields.modalSaveButton",
    defaultMessage: "Save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 15
    }
  }))))));
};
exports.HighlightedFieldsModal = HighlightedFieldsModal;