"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_get_flyout_link = require("../hooks/use_get_flyout_link");
var _use_basic_data_from_details_data = require("../../shared/hooks/use_basic_data_from_details_data");
var _context = require("../../shared/context");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/header_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Actions displayed in the header menu in the right section of alerts flyout
 */
const HeaderActions = exports.HeaderActions = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    dataFormattedForFieldBrowser,
    eventId,
    indexName
  } = (0, _context.useDocumentDetailsContext)();
  const {
    isAlert,
    timestamp
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const alertDetailsLink = (0, _use_get_flyout_link.useGetFlyoutLink)({
    eventId,
    indexName,
    timestamp
  });
  const showShareAlertButton = isAlert && alertDetailsLink;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, showShareAlertButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.securitySolution.flyout.right.header.shareButtonToolTip', {
      defaultMessage: 'Share alert'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: alertDetailsLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: 'share',
    color: 'text',
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.header.shareButtonAriaLabel', {
      defaultMessage: 'Share alert'
    }),
    "data-test-subj": _test_ids.SHARE_BUTTON_TEST_ID,
    onClick: copy,
    onKeyDown: copy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 17
    }
  })))));
});
HeaderActions.displayName = 'HeaderActions';