"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnrichmentRangePicker = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _test_ids = require("./test_ids");
var _constants = require("../../../../../common/cti/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/threat_intelligence_view_enrichment_range_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ENRICHMENT_LOOKBACK_START_DATE = _i18n.i18n.translate('xpack.securitySolution.flyout.threatIntelligence.enrichmentQueryStartDate', {
  defaultMessage: 'Start date'
});
const ENRICHMENT_LOOKBACK_END_DATE = _i18n.i18n.translate('xpack.securitySolution.flyout.threatIntelligence.enrichmentQueryEndDate', {
  defaultMessage: 'End date'
});
const REFRESH = _i18n.i18n.translate('xpack.securitySolution.flyout.threatIntelligence.refresh', {
  defaultMessage: 'Refresh'
});
/**
 * A component that allows the user to select a range of dates for enrichment
 */
const EnrichmentRangePicker = exports.EnrichmentRangePicker = /*#__PURE__*/(0, _react.memo)(({
  range,
  setRange,
  loading
}) => {
  const [startDate, setStartDate] = (0, _react.useState)(range.from === _constants.DEFAULT_EVENT_ENRICHMENT_FROM ? (0, _moment.default)().subtract(30, 'd') : (0, _moment.default)(range.from));
  const [endDate, setEndDate] = (0, _react.useState)(range.to === _constants.DEFAULT_EVENT_ENRICHMENT_TO ? (0, _moment.default)() : (0, _moment.default)(range.to));
  const onButtonClick = (0, _react.useCallback)(() => {
    if (startDate && endDate && startDate.isBefore(endDate)) {
      setRange({
        from: startDate.toISOString(),
        to: endDate.toISOString()
      });
    }
  }, [endDate, setRange, startDate]);
  const isValid = (0, _react.useMemo)(() => startDate === null || startDate === void 0 ? void 0 : startDate.isBefore(endDate), [startDate, endDate]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
    "data-test-subj": _test_ids.THREAT_INTELLIGENCE_ENRICHMENTS_RANGE_PICKER_TEST_ID,
    startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      className: "start-picker",
      selected: startDate,
      onChange: setStartDate,
      startDate: startDate,
      endDate: endDate,
      isInvalid: !isValid,
      "aria-label": ENRICHMENT_LOOKBACK_START_DATE,
      showTimeSelect: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 13
      }
    }),
    endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      className: "end-picker",
      selected: endDate,
      onChange: setEndDate,
      startDate: startDate,
      endDate: endDate,
      isInvalid: !isValid,
      "aria-label": ENRICHMENT_LOOKBACK_END_DATE,
      showTimeSelect: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: 'refresh',
    onClick: onButtonClick,
    isLoading: loading,
    "data-test-subj": _test_ids.THREAT_INTELLIGENCE_ENRICHMENTS_REFRESH_BUTTON_TEST_ID,
    isDisabled: !isValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, REFRESH)));
});
EnrichmentRangePicker.displayName = 'EnrichmentRangePicker';