"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNetworkTopCountriesColumns = exports.getCountriesColumnsCurated = void 0;
var _fp = require("lodash/fp");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireDefault(require("react"));
var _cell_actions = require("../../../../common/components/cell_actions");
var _country_flag = require("../source_destination/country_flag");
var _network = require("../../../../../common/search_strategy/security_solution/network");
var _store = require("../../store");
var _helpers = require("../../../../common/components/drag_and_drop/helpers");
var _empty_value = require("../../../../common/components/empty_value");
var i18n = _interopRequireWildcard(require("./translations"));
var _formatted_bytes = require("../../../../common/components/formatted_bytes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/network_top_countries_table/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getNetworkTopCountriesColumns = (flowTarget, type, tableId) => [{
  name: i18n.COUNTRY,
  render: ({
    node
  }) => {
    const geo = (0, _fp.get)(`${flowTarget}.country`, node);
    const geoAttr = `${flowTarget}.geo.country_iso_code`;
    const id = (0, _helpers.escapeDataProviderId)(`${tableId}-table-${flowTarget}-country-${geo}`);
    if (geo != null) {
      return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
        key: id,
        mode: _cell_actions.CellActionsMode.HOVER_DOWN,
        visibleCellActions: 5,
        showActionTooltips: true,
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        data: {
          value: geo,
          field: geoAttr
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_country_flag.CountryFlagAndName, {
        countryCode: geo,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 13
        }
      }));
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  },
  width: '20%'
}, {
  align: 'right',
  field: 'node.network.bytes_in',
  name: i18n.BYTES_IN,
  sortable: true,
  render: bytes => {
    if (bytes != null) {
      return /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
        value: bytes,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 16
        }
      });
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: 'node.network.bytes_out',
  name: i18n.BYTES_OUT,
  sortable: true,
  render: bytes => {
    if (bytes != null) {
      return /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
        value: bytes,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 16
        }
      });
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: `node.${flowTarget}.flows`,
  name: i18n.FLOWS,
  sortable: true,
  render: flows => {
    if (flows != null) {
      return (0, _numeral.default)(flows).format('0,000');
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: `node.${flowTarget}.${flowTarget}_ips`,
  name: flowTarget === _network.FlowTargetSourceDest.source ? i18n.SOURCE_IPS : i18n.DESTINATION_IPS,
  sortable: true,
  render: ips => {
    if (ips != null) {
      return (0, _numeral.default)(ips).format('0,000');
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: `node.${flowTarget}.${getOppositeField(flowTarget)}_ips`,
  name: getOppositeField(flowTarget) === _network.FlowTargetSourceDest.source ? i18n.SOURCE_IPS : i18n.DESTINATION_IPS,
  sortable: true,
  render: ips => {
    if (ips != null) {
      return (0, _numeral.default)(ips).format('0,000');
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}];
exports.getNetworkTopCountriesColumns = getNetworkTopCountriesColumns;
const getCountriesColumnsCurated = (flowTarget, type, tableId) => {
  const columns = getNetworkTopCountriesColumns(flowTarget, type, tableId);

  // Columns to exclude from host details pages
  if (type === _store.networkModel.NetworkType.details) {
    columns.pop();
    return columns;
  }
  return columns;
};
exports.getCountriesColumnsCurated = getCountriesColumnsCurated;
const getOppositeField = flowTarget => flowTarget === _network.FlowTargetSourceDest.source ? _network.FlowTargetSourceDest.destination : _network.FlowTargetSourceDest.source;