"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostDetailsTabs = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _types = require("../../../../../common/entity_analytics/types");
var _risk_details_tab_body = require("../../../../entity_analytics/components/risk_details_tab_body");
var _model = require("../../store/model");
var _anomalies_query_tab_body = require("../../../../common/containers/anomalies/anomalies_query_tab_body");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _anomalies_host_table = require("../../../../common/components/ml/tables/anomalies_host_table");
var _events_tab = require("../../../../common/components/events_tab");
var _navigation = require("../navigation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/hosts/pages/details/details_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const HostDetailsTabs = exports.HostDetailsTabs = /*#__PURE__*/_react.default.memo(({
  detailName,
  filterQuery,
  indexNames,
  hostDetailsPagePath,
  hostDetailsFilter
}) => {
  const {
    from,
    to,
    isInitializing,
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const tabProps = {
    deleteQuery,
    endDate: to,
    filterQuery,
    skip: isInitializing || filterQuery === undefined,
    setQuery,
    startDate: from,
    type: _model.HostsType.details,
    indexNames,
    hostName: detailName
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${hostDetailsPagePath}/:tabName(${_model.HostsTableType.authentications})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.AuthenticationsQueryTabBody, (0, _extends2.default)({}, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${hostDetailsPagePath}/:tabName(${_model.HostsTableType.uncommonProcesses})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.UncommonProcessQueryTabBody, (0, _extends2.default)({}, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${hostDetailsPagePath}/:tabName(${_model.HostsTableType.anomalies})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_anomalies_query_tab_body.AnomaliesQueryTabBody, (0, _extends2.default)({}, tabProps, {
    AnomaliesTableComponent: _anomalies_host_table.AnomaliesHostTable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${hostDetailsPagePath}/:tabName(${_model.HostsTableType.events})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_events_tab.EventsQueryTabBody, (0, _extends2.default)({
    additionalFilters: hostDetailsFilter,
    tableId: _securitysolutionDataTable.TableId.hostsPageEvents
  }, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${hostDetailsPagePath}/:tabName(${_model.HostsTableType.risk})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_risk_details_tab_body.RiskDetailsTabBody, (0, _extends2.default)({}, tabProps, {
    riskEntity: _types.EntityType.host,
    entityName: tabProps.hostName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${hostDetailsPagePath}/:tabName(${_model.HostsTableType.sessions})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.SessionsTabBody, (0, _extends2.default)({}, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }))));
});
HostDetailsTabs.displayName = 'HostDetailsTabs';