"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskContributingAlerts = void 0;
var _react = require("react");
var _use_query = require("../../detections/containers/detection_engine/alerts/use_query");
var _constants = require("../../detections/containers/detection_engine/alerts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetches alerts related to the risk score
 */
const useRiskContributingAlerts = ({
  riskScore,
  entityType
}) => {
  const {
    loading,
    data,
    setQuery
  } = (0, _use_query.useQueryAlerts)({
    query: {},
    queryName: _constants.ALERTS_QUERY_NAMES.BY_ID
  });
  const inputs = getInputs(riskScore, entityType);
  (0, _react.useEffect)(() => {
    if (!riskScore) return;
    setQuery({
      query: {
        ids: {
          values: inputs.map(input => input.id)
        }
      }
    });
  }, [riskScore, inputs, setQuery]);
  const error = !loading && data === undefined;
  const alerts = inputs.map(input => {
    var _data$hits$hits$find;
    return {
      _id: input.id,
      input,
      alert: (data === null || data === void 0 ? void 0 : (_data$hits$hits$find = data.hits.hits.find(alert => alert._id === input.id)) === null || _data$hits$hits$find === void 0 ? void 0 : _data$hits$hits$find._source) || {}
    };
  });
  return {
    loading,
    error,
    data: alerts
  };
};
exports.useRiskContributingAlerts = useRiskContributingAlerts;
const getInputs = (riskScore, entityType) => {
  if (!riskScore) {
    return [];
  }
  return riskScore[entityType].risk.inputs;
};