"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetCriticalityFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _multiselect_filter = require("../../../common/components/multiselect_filter");
var _constants = require("../../../../common/constants");
var _asset_criticality_badge = require("./asset_criticality_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/asset_criticality/asset_criticality_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ASSET_CRITICALITY_OPTIONS = [_constants.CriticalityLevels.EXTREME_IMPACT, _constants.CriticalityLevels.HIGH_IMPACT, _constants.CriticalityLevels.MEDIUM_IMPACT, _constants.CriticalityLevels.LOW_IMPACT];
const AssetCriticalityFilter = ({
  selectedItems,
  onChange
}) => {
  const renderItem = (0, _react.useCallback)(level => {
    return /*#__PURE__*/_react.default.createElement(_asset_criticality_badge.AssetCriticalityBadge, {
      criticalityLevel: level,
      css: {
        lineHeight: 'inherit'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 12
      }
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_multiselect_filter.MultiselectFilter, {
    title: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.assetCriticality.filterTitle', {
      defaultMessage: 'Criticality'
    }),
    items: ASSET_CRITICALITY_OPTIONS,
    selectedItems: selectedItems,
    onSelectionChange: onChange,
    renderItem: renderItem,
    width: 190,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  });
};
exports.AssetCriticalityFilter = AssetCriticalityFilter;