"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvestigateInTimeline = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _lodash = require("lodash");
var _helpers = require("../../../../common/utils/global_query_string/helpers");
var _kibana = require("../../../../common/lib/kibana");
var _timeline = require("../../../../../common/types/timeline");
var _timeline2 = require("../../../../../common/api/timeline");
var _actions = require("../actions");
var _use_update_timeline = require("../../../../timelines/components/open_timeline/use_update_timeline");
var _use_create_timeline = require("../../../../timelines/hooks/use_create_timeline");
var _translations = require("../translations");
var _helpers2 = require("../../../../helpers");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _default_headers = require("../../../../timelines/components/timeline/body/column_headers/default_headers");
var _user_privileges = require("../../../../common/components/user_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const detectionExceptionList = ecsData => {
  var _getField;
  let exceptionsList = (_getField = (0, _helpers2.getField)(ecsData, _ruleDataUtils.ALERT_RULE_EXCEPTIONS_LIST)) !== null && _getField !== void 0 ? _getField : [];
  let detectionExceptionsList = [];
  try {
    if (Array.isArray(exceptionsList) && exceptionsList.length === 0) {
      var _getField2;
      const ruleParameters = (_getField2 = (0, _helpers2.getField)(ecsData, _ruleDataUtils.ALERT_RULE_PARAMETERS)) !== null && _getField2 !== void 0 ? _getField2 : {};
      if (ruleParameters.length > 0) {
        var _parametersObject$exc;
        const parametersObject = JSON.parse(ruleParameters[0]);
        exceptionsList = (_parametersObject$exc = parametersObject === null || parametersObject === void 0 ? void 0 : parametersObject.exceptions_list) !== null && _parametersObject$exc !== void 0 ? _parametersObject$exc : [];
      }
    } else if (exceptionsList && exceptionsList.list_id) {
      return exceptionsList.list_id.map((listId, index) => {
        const type = exceptionsList.type[index];
        return {
          exception_list_id: listId,
          namespace_type: exceptionsList.namespace_type[index],
          type
        };
      }).filter(exception => exception.type === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION);
    }
  } catch (error) {
    // do nothing, just fail silently as parametersObject is initialized
  }
  detectionExceptionsList = exceptionsList.reduce((acc, next) => {
    // parsed rule.parameters returns an object else use the default string representation
    try {
      const parsedList = typeof next === 'string' ? JSON.parse(next) : next;
      if (parsedList.type === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION) {
        const formattedList = {
          exception_list_id: parsedList.list_id,
          namespace_type: parsedList.namespace_type
        };
        acc.push(formattedList);
      }
      // eslint-disable-next-line no-empty
    } catch {}
    return acc;
  }, []);
  return detectionExceptionsList;
};
const useInvestigateInTimeline = ({
  ecsRowData,
  onInvestigateInTimelineAlertClick
}) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    data: {
      search: searchStrategyClient
    }
  } = (0, _kibana.useKibana)().services;
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const {
    services
  } = (0, _kibana.useKibana)();
  const {
    getExceptionFilterFromIds
  } = (0, _securitysolutionListHooks.useApi)(services.http);
  const getExceptionFilter = (0, _react.useCallback)(async ecsData => {
    // This pulls exceptions list information from `_source` for timeline or the fields api for alerts.
    const detectionExceptionsLists = detectionExceptionList(ecsData);
    let exceptionFilter;
    if (detectionExceptionsLists.length > 0) {
      await getExceptionFilterFromIds({
        exceptionListIds: detectionExceptionsLists,
        excludeExceptions: true,
        chunkSize: 20,
        alias: 'Exceptions',
        onSuccess: filter => {
          exceptionFilter = filter;
        },
        onError: err => {
          addError(err, {
            title: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.fetchExceptionFilterFailure', {
              defaultMessage: 'Error fetching exception filter.'
            })
          });
        }
      });
    }
    return exceptionFilter;
  }, [addError, getExceptionFilterFromIds]);
  const clearActiveTimeline = (0, _use_create_timeline.useCreateTimeline)({
    timelineId: _timeline.TimelineId.active,
    timelineType: _timeline2.TimelineTypeEnum.default
  });
  const updateTimeline = (0, _use_update_timeline.useUpdateTimeline)();
  const createTimeline = (0, _react.useCallback)(async ({
    from: fromTimeline,
    timeline,
    to: toTimeline,
    ruleNote
  }) => {
    var _timeline$indexNames;
    const newColumns = timeline.columns;
    const newColumnsOverride = !newColumns || (0, _lodash.isEmpty)(newColumns) ? _default_headers.defaultUdtHeaders : newColumns;
    await clearActiveTimeline();
    updateTimeline({
      duplicate: true,
      from: fromTimeline,
      id: _timeline.TimelineId.active,
      notes: [],
      timeline: {
        ...timeline,
        columns: newColumnsOverride,
        indexNames: (_timeline$indexNames = timeline.indexNames) !== null && _timeline$indexNames !== void 0 ? _timeline$indexNames : [],
        show: true,
        excludedRowRendererIds: timeline.timelineType !== _timeline2.TimelineTypeEnum.template ? timeline.excludedRowRendererIds : []
      },
      to: toTimeline,
      ruleNote
    });
  }, [updateTimeline, clearActiveTimeline]);
  const investigateInTimelineAlertClick = (0, _react.useCallback)(async () => {
    (0, _helpers.createHistoryEntry)();
    startTransaction({
      name: _user_actions.ALERTS_ACTIONS.INVESTIGATE_IN_TIMELINE
    });
    if (onInvestigateInTimelineAlertClick) {
      onInvestigateInTimelineAlertClick();
    }
    if (ecsRowData != null) {
      await (0, _actions.sendAlertToTimelineAction)({
        createTimeline,
        ecsData: ecsRowData,
        searchStrategyClient,
        getExceptionFilter
      });
    }
  }, [startTransaction, createTimeline, ecsRowData, onInvestigateInTimelineAlertClick, searchStrategyClient, getExceptionFilter]);
  const {
    timelinePrivileges: {
      read: canInvestigateInTimeline
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const investigateInTimelineActionItems = (0, _react.useMemo)(() => canInvestigateInTimeline ? [{
    key: 'investigate-in-timeline-action-item',
    'data-test-subj': 'investigate-in-timeline-action-item',
    disabled: ecsRowData == null,
    onClick: investigateInTimelineAlertClick,
    name: _translations.ACTION_INVESTIGATE_IN_TIMELINE
  }] : [], [ecsRowData, investigateInTimelineAlertClick, canInvestigateInTimeline]);
  return {
    investigateInTimelineActionItems,
    investigateInTimelineAlertClick
  };
};
exports.useInvestigateInTimeline = useInvestigateInTimeline;