"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderSection = exports.GO_TO_RULES_BUTTON_TEST_ID = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _filter_by_assignees_popover = require("../../../../common/components/filter_by_assignees_popover/filter_by_assignees_popover");
var _types = require("../../../../app/types");
var _links = require("../../../../common/components/links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts/header/header_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BUTTON_MANAGE_RULES = _i18n.i18n.translate('xpack.securitySolution.alertsPage.buttonManageRules', {
  defaultMessage: 'Manage rules'
});
const GO_TO_RULES_BUTTON_TEST_ID = exports.GO_TO_RULES_BUTTON_TEST_ID = 'alerts-page-manage-alert-detection-rules';
/**
 * UI section of the alerts page that renders the assignees button and a button to navigate to the rules page.
 */
const HeaderSection = exports.HeaderSection = /*#__PURE__*/(0, _react.memo)(({
  assignees,
  setAssignees
}) => {
  const handleSelectedAssignees = (0, _react.useCallback)(newAssignees => {
    if (!(0, _lodash.isEqual)(newAssignees, assignees)) {
      setAssignees(newAssignees);
    }
  }, [assignees, setAssignees]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_filter_by_assignees_popover.FilterByAssigneesPopover, {
    selectedUserIds: assignees,
    onSelectionChange: handleSelectedAssignees,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    deepLinkId: _types.SecurityPageName.rules,
    "data-test-subj": GO_TO_RULES_BUTTON_TEST_ID,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, BUTTON_MANAGE_RULES)));
});
HeaderSection.displayName = 'HeaderSection';