"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.responseActionTypes = exports.getSupportedResponseActions = void 0;
var _rule_response_actions = require("../../../common/api/detection_engine/model/rule_response_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSupportedResponseActions = (actionTypes, userPermissions) => actionTypes.reduce((acc, actionType) => {
  const isEndpointAction = actionType.id === _rule_response_actions.ResponseActionTypesEnum['.endpoint'];
  if (_rule_response_actions.ResponseActionTypes.options.includes(actionType.id)) return [...acc, {
    ...actionType,
    disabled: isEndpointAction ? !userPermissions.endpoint : undefined
  }];
  return acc;
}, []);
exports.getSupportedResponseActions = getSupportedResponseActions;
const responseActionTypes = exports.responseActionTypes = [{
  id: _rule_response_actions.ResponseActionTypesEnum['.osquery'],
  name: 'Osquery',
  iconClass: 'logoOsquery'
}, {
  id: _rule_response_actions.ResponseActionTypesEnum['.endpoint'],
  name: 'Elastic Defend',
  iconClass: 'logoSecurity'
}];