"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsViewerItems = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _exception_item_card = require("../exception_item_card");
var _empty_viewer_state = require("./empty_viewer_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/all_exception_items_table/all_items.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MyFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin: ${({
  theme
}) => `${theme.eui.euiSize} 0`};
  &:first-child {
    margin: ${({
  theme
}) => `${theme.eui.euiSizeXS} 0 ${theme.eui.euiSize}`};
  }
`;
const ExceptionItemsViewerComponent = ({
  isReadOnly,
  exceptions,
  isEndpoint,
  disableActions,
  ruleReferences,
  viewerState,
  onCreateExceptionListItem,
  onDeleteException,
  onEditExceptionItem
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, viewerState != null && viewerState !== 'deleting' ? /*#__PURE__*/_react.default.createElement(_empty_viewer_state.ExeptionItemsViewerEmptyPrompts, {
    isReadOnly: isReadOnly,
    isEndpoint: isEndpoint,
    currentState: viewerState,
    onCreateExceptionListItem: onCreateExceptionListItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    className: "eui-yScrollWithShadows",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-yScrollWithShadows",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "exceptionsContainer",
    gutterSize: "none",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  }, exceptions.map(exception => /*#__PURE__*/_react.default.createElement(MyFlexItem, {
    "data-test-subj": "exceptionItemContainer",
    grow: false,
    key: exception.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_exception_item_card.ExceptionItemCard, {
    disableActions: disableActions,
    exceptionItem: exception,
    isEndpoint: isEndpoint,
    listAndReferences: ruleReferences != null ? ruleReferences[exception.list_id] : null,
    onDeleteException: onDeleteException,
    onEditException: onEditExceptionItem,
    dataTestSubj: "exceptionItemsViewerItem",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 19
    }
  })))))));
};
ExceptionItemsViewerComponent.displayName = 'ExceptionItemsViewerComponent';
const ExceptionsViewerItems = exports.ExceptionsViewerItems = /*#__PURE__*/_react.default.memo(ExceptionItemsViewerComponent);
ExceptionsViewerItems.displayName = 'ExceptionsViewerItems';