"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventsQueryTabBody = exports.ALERTS_EVENTS_HISTOGRAM_ID = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_bulk_event_actions = require("../../../cases/components/case_events/use_bulk_event_actions");
var _use_experimental_features = require("../../hooks/use_experimental_features");
var _timeline = require("../../../../common/api/timeline");
var _events_viewer = require("../events_viewer");
var _default_model = require("../events_viewer/default_model");
var _matrix_histogram = require("../matrix_histogram");
var _use_full_screen = require("../../containers/use_full_screen");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../../common/constants");
var _histogram_configurations = require("./histogram_configurations");
var _control_columns = require("../../../timelines/components/timeline/body/control_columns");
var _renderers = require("../../../timelines/components/timeline/body/renderers");
var _default_cell_renderer = require("../../../timelines/components/timeline/cell_rendering/default_cell_renderer");
var _model = require("../../../sourcerer/store/model");
var _use_license = require("../../hooks/use_license");
var _kibana = require("../../lib/kibana");
var _external_alerts_filter = require("../events_viewer/external_alerts_filter");
var _use_add_bulk_to_timeline = require("../../../detections/components/alerts_table/timeline_actions/use_add_bulk_to_timeline");
var _helpers = require("../../utils/global_query_string/helpers");
var _cell_actions = require("../cell_actions");
var _user_privileges = require("../user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/events_tab/events_query_tab_body.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALERTS_EVENTS_HISTOGRAM_ID = exports.ALERTS_EVENTS_HISTOGRAM_ID = 'alertsOrEventsHistogramQuery';
const EXTERNAL_ALERTS_URL_PARAM = 'onlyExternalAlerts';

// we show a maximum of 6 action buttons
// - open flyout
// - investigate in timeline
// - 3-dot menu for more actions
// - add new note
// - session view
// - analyzer graph
const MAX_ACTION_BUTTON_COUNT = 6;
const EventsQueryTabBodyComponent = ({
  additionalFilters,
  deleteQuery,
  endDate,
  filterQuery,
  startDate,
  tableId
}) => {
  let ACTION_BUTTON_COUNT = MAX_ACTION_BUTTON_COUNT;
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  if (!isEnterprisePlus) {
    ACTION_BUTTON_COUNT--;
  }
  const {
    notesPrivileges: {
      read: canReadNotes
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const securitySolutionNotesDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('securitySolutionNotesDisabled');
  if (!canReadNotes || securitySolutionNotesDisabled) {
    ACTION_BUTTON_COUNT--;
  }
  const leadingControlColumns = (0, _react.useMemo)(() => (0, _control_columns.getDefaultControlColumn)(ACTION_BUTTON_COUNT), [ACTION_BUTTON_COUNT]);
  const showExternalAlertsInitialUrlState = useExternalAlertsInitialUrlState();
  const [showExternalAlerts, setShowExternalAlerts] = (0, _react.useState)(showExternalAlertsInitialUrlState !== null && showExternalAlertsInitialUrlState !== void 0 ? showExternalAlertsInitialUrlState : false);
  useSyncExternalAlertsUrlState(showExternalAlerts);
  const toggleExternalAlerts = (0, _react.useCallback)(() => setShowExternalAlerts(s => !s), []);
  const getHistogramSubtitle = (0, _react.useMemo)(() => (0, _histogram_configurations.getSubtitleFunction)(defaultNumberFormat, showExternalAlerts), [defaultNumberFormat, showExternalAlerts]);
  (0, _react.useEffect)(() => {
    dispatch(_securitysolutionDataTable.dataTableActions.initializeDataTableSettings({
      id: tableId,
      defaultColumns: _default_model.eventsDefaultModel.columns,
      title: i18n.EVENTS_GRAPH_TITLE,
      showCheckboxes: true,
      selectAll: true
    }));
  }, [dispatch, showExternalAlerts, tableId]);
  (0, _react.useEffect)(() => {
    return () => {
      if (deleteQuery) {
        deleteQuery({
          id: ALERTS_EVENTS_HISTOGRAM_ID
        });
      }
    };
  }, [deleteQuery]);
  const toggleExternalAlertsCheckbox = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "showExternalAlertsCheckbox",
    "data-test-subj": "showExternalAlertsCheckbox",
    "aria-label": i18n.SHOW_EXTERNAL_ALERTS,
    checked: showExternalAlerts,
    color: "text",
    label: i18n.SHOW_EXTERNAL_ALERTS,
    onChange: toggleExternalAlerts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }), [showExternalAlerts, toggleExternalAlerts]);
  const defaultModel = (0, _react.useMemo)(() => ({
    ..._default_model.eventsDefaultModel,
    excludedRowRendererIds: showExternalAlerts ? _timeline.RowRendererValues : []
  }), [showExternalAlerts]);
  const composedPageFilters = (0, _react.useMemo)(() => showExternalAlerts ? [_external_alerts_filter.defaultAlertsFilters, ...additionalFilters] : additionalFilters, [additionalFilters, showExternalAlerts]);
  const addBulkToTimelineAction = (0, _use_add_bulk_to_timeline.useAddBulkToTimelineAction)({
    localFilters: composedPageFilters,
    tableId,
    from: startDate,
    to: endDate,
    scopeId: _model.SourcererScopeName.default
  });
  const caseEventsBulkActions = (0, _use_bulk_event_actions.useBulkAddEventsToCaseActions)({
    clearSelection: () => dispatch(_securitysolutionDataTable.dataTableActions.clearSelected({
      id: tableId
    }))
  });
  const bulkActions = (0, _react.useMemo)(() => {
    return {
      alertStatusActions: false,
      customBulkActions: [addBulkToTimelineAction, ...caseEventsBulkActions]
    };
  }, [addBulkToTimelineAction, caseEventsBulkActions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !globalFullScreen && /*#__PURE__*/_react.default.createElement(_matrix_histogram.MatrixHistogram, (0, _extends2.default)({
    id: ALERTS_EVENTS_HISTOGRAM_ID,
    startDate: startDate,
    endDate: endDate,
    filterQuery: filterQuery
  }, showExternalAlerts ? _histogram_configurations.alertsHistogramConfig : _histogram_configurations.eventsHistogramConfig, {
    subtitle: getHistogramSubtitle,
    sourcererScopeId: newDataViewPickerEnabled ? _model.SourcererScopeName.explore : _model.SourcererScopeName.default,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_events_viewer.StatefulEventsViewer, {
    topRightMenuOptions: toggleExternalAlertsCheckbox,
    cellActionsTriggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
    start: startDate,
    end: endDate,
    leadingControlColumns: leadingControlColumns,
    renderCellValue: _default_cell_renderer.DefaultCellRenderer,
    rowRenderers: _renderers.defaultRowRenderers,
    sourcererScope: newDataViewPickerEnabled ? _model.SourcererScopeName.explore : _model.SourcererScopeName.default,
    tableId: tableId,
    unit: showExternalAlerts ? i18n.EXTERNAL_ALERTS_UNIT : i18n.EVENTS_UNIT,
    defaultModel: defaultModel,
    pageFilters: composedPageFilters,
    bulkActions: bulkActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }));
};
EventsQueryTabBodyComponent.displayName = 'EventsQueryTabBodyComponent';
const EventsQueryTabBody = exports.EventsQueryTabBody = /*#__PURE__*/_react.default.memo(EventsQueryTabBodyComponent);
EventsQueryTabBody.displayName = 'EventsQueryTabBody';
const useExternalAlertsInitialUrlState = () => {
  const replaceUrlParams = (0, _helpers.useReplaceUrlParams)();
  const getInitialUrlParamValue = (0, _helpers.useGetInitialUrlParamValue)(EXTERNAL_ALERTS_URL_PARAM);
  const showExternalAlertsInitialUrlState = (0, _react.useMemo)(() => getInitialUrlParamValue(), [getInitialUrlParamValue]);
  (0, _react.useEffect)(() => {
    // Only called on component unmount
    return () => {
      replaceUrlParams({
        [EXTERNAL_ALERTS_URL_PARAM]: null
      });
    };
  }, [replaceUrlParams]);
  return showExternalAlertsInitialUrlState;
};

/**
 * Update URL state when showExternalAlerts value changes
 */
const useSyncExternalAlertsUrlState = showExternalAlerts => {
  const replaceUrlParams = (0, _helpers.useReplaceUrlParams)();
  (0, _react.useEffect)(() => {
    replaceUrlParams({
      [EXTERNAL_ALERTS_URL_PARAM]: showExternalAlerts ? true : null
    });
  }, [showExternalAlerts, replaceUrlParams]);
};