"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DonutChartWrapper = exports.DonutChart = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _common = require("./common");
var _draggable_legend = require("./draggable_legend");
var _donutchart_empty = require("./donutchart_empty");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/charts/donutchart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const donutTheme = {
  chartMargins: {
    top: 0,
    bottom: 0,
    left: 0,
    right: 0
  },
  partition: {
    idealFontSizeJump: 1.1,
    outerSizeRatio: 1,
    emptySizeRatio: 0.8,
    circlePadding: 4
  }
};
const getStyles = (dataExists, isChartEmbeddablesEnabled, donutTextWrapperStyles, className) => {
  return {
    donutTextWrapper: (0, _react2.css)`
      top: ${isChartEmbeddablesEnabled && !dataExists ? '66%' : '34%'};
      width: 100%;
      max-width: 75%;
      position: absolute; // Make this position absolute in order to overlap the text onto the donut
      z-index: 1;

      ${className && donutTextWrapperStyles ? `&.${className} {${donutTextWrapperStyles}}` : ''}
    `,
    flexItem: (0, _react2.css)`
      position: relative;
      align-items: center;
    `
  };
};
const DonutChartWrapperComponent = ({
  children,
  dataExists,
  donutTextWrapperClassName,
  donutTextWrapperStyles,
  isChartEmbeddablesEnabled,
  label,
  title
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = getStyles(dataExists, isChartEmbeddablesEnabled, donutTextWrapperStyles, donutTextWrapperClassName);
  const emptyLabelStyle = (0, _react.useMemo)(() => ({
    color: euiTheme.colors.textSubdued
  }), [euiTheme.colors.textSubdued]);
  const className = isChartEmbeddablesEnabled ? undefined : 'eui-textTruncate';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    responsive: false,
    gutterSize: "l",
    "data-test-subj": "donut-chart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.flexItem,
    grow: isChartEmbeddablesEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.donutTextWrapper,
    alignItems: "center",
    className: donutTextWrapperClassName,
    direction: "column",
    gutterSize: "none",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, title), label && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: className,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    className: className,
    size: "s",
    css: dataExists ? undefined : emptyLabelStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }, label)))), children));
};
const DonutChartWrapper = exports.DonutChartWrapper = /*#__PURE__*/_react.default.memo(DonutChartWrapperComponent);
const DonutChart = ({
  data,
  fillColor,
  height = 90,
  label,
  legendItems,
  onPartitionClick,
  title,
  totalCount
}) => {
  const {
    baseTheme,
    theme
  } = (0, _common.useThemes)();
  const onElementClicked = (0, _react.useCallback)(event => {
    if (onPartitionClick) {
      var _flattened$;
      const flattened = event.flat(2);
      const level = flattened.length > 0 && 'groupByRollup' in flattened[0] && ((_flattened$ = flattened[0]) === null || _flattened$ === void 0 ? void 0 : _flattened$.groupByRollup) != null ? `${flattened[0].groupByRollup}` : '';
      if (!(0, _lodash.isEmpty)(level.trim())) {
        onPartitionClick(level);
      }
    }
  }, [onPartitionClick]);
  return /*#__PURE__*/_react.default.createElement(DonutChartWrapper, {
    dataExists: data != null && data.length > 0,
    label: label,
    title: title,
    isChartEmbeddablesEnabled: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data == null || totalCount == null || totalCount === 0 ? /*#__PURE__*/_react.default.createElement(_donutchart_empty.DonutChartEmpty, {
    size: height,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: height,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [donutTheme, theme],
    baseTheme: baseTheme,
    onElementClick: onElementClicked,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    id: "donut-chart",
    data: data,
    layout: _charts.PartitionLayout.sunburst,
    valueAccessor: d => d.value,
    valueFormatter: d => `${(0, _charts.defaultPartitionValueFormatter)(d)}`,
    layers: [{
      groupByRollup: d => {
        var _d$label;
        return (_d$label = d.label) !== null && _d$label !== void 0 ? _d$label : d.key;
      },
      nodeLabel: d => d,
      shape: {
        fillColor
      }
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  })), legendItems && (legendItems === null || legendItems === void 0 ? void 0 : legendItems.length) > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_draggable_legend.DraggableLegend, {
    legendItems: legendItems,
    height: height,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 13
    }
  }))));
};
exports.DonutChart = DonutChart;