"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Cases = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _common = require("@kbn/cases-plugin/common");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _panel_keys = require("../../flyout/ai_for_soc/constants/panel_keys");
var _alerts_table = require("../../detections/components/alerts_table");
var _endpoint = require("../../common/components/endpoint");
var _panel_keys2 = require("../../flyout/document_details/shared/constants/panel_keys");
var _right = require("../../flyout/rule_details/right");
var _timeline = require("../../../common/types/timeline");
var _kibana = require("../../common/lib/kibana");
var _constants = require("../../../common/constants");
var _store = require("../../timelines/store");
var _page_wrapper = require("../../common/components/page_wrapper");
var _routing = require("../../management/common/routing");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _use_insert_timeline = require("../components/use_insert_timeline");
var _user_privileges = require("../../common/components/user_privileges");
var timelineMarkdownPlugin = _interopRequireWildcard(require("../../common/components/markdown_editor/plugins/timeline"));
var _use_fetch_alert_data = require("./use_fetch_alert_data");
var _use_upselling = require("../../common/hooks/use_upselling");
var _use_fetch_notes = require("../../notes/hooks/use_fetch_notes");
var _telemetry = require("../../common/lib/telemetry");
var _wrapper = require("../components/ai_for_soc/wrapper");
var _table = require("../components/case_events/table");
var _ = require("..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/cases/pages/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CaseContainerComponent = () => {
  const {
    application: {
      capabilities
    },
    cases,
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    getAppUrl,
    navigateTo
  } = (0, _kibana.useNavigation)();
  const userCasesPermissions = cases.helpers.canUseCases([_constants.APP_ID]);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    timelinePrivileges: {
      read: canSeeTimeline
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const interactionsUpsellingMessage = (0, _use_upselling.useUpsellingMessage)('investigation_guide_interactions');

  // TODO We shouldn't have to check capabilities here, this should be done at a much higher level.
  //  https://github.com/elastic/kibana/issues/218741
  const AIForSOC = capabilities[_constants.SECURITY_FEATURE_ID].configurations;
  const showAlertDetails = (0, _react.useCallback)((alertId, index) => {
    //  For the AI for SOC we need to show the AI alert flyout.
    if (AIForSOC) {
      openFlyout({
        right: {
          id: _panel_keys.IOCPanelKey,
          params: {
            id: alertId,
            indexName: index
          }
        }
      });
    } else {
      openFlyout({
        right: {
          id: _panel_keys2.DocumentDetailsRightPanelKey,
          params: {
            id: alertId,
            indexName: index,
            scopeId: _timeline.TimelineId.casePage
          }
        }
      });
      telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
        location: _timeline.TimelineId.casePage,
        panel: 'right'
      });
    }
  }, [AIForSOC, openFlyout, telemetry]);
  const renderAlertsTable = (0, _react.useCallback)(props => {
    //  For the AI for SOC we need to show the Alert summary page alerts table.
    if (AIForSOC) {
      return /*#__PURE__*/_react.default.createElement(_wrapper.AiForSOCAlertsTable, {
        id: props.id,
        onLoaded: props.onLoaded,
        query: props.query,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 16
        }
      });
    } else {
      return /*#__PURE__*/_react.default.createElement(_alerts_table.AlertsTable, (0, _extends2.default)({
        tableType: _securitysolutionDataTable.TableId.alertsOnCasePage
      }, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 16
        }
      }));
    }
  }, [AIForSOC]);
  const onRuleDetailsClick = (0, _react.useCallback)(ruleId => {
    if (ruleId) {
      openFlyout({
        right: {
          id: _right.RulePanelKey,
          params: {
            ruleId
          }
        }
      });
    }
  }, [openFlyout]);
  const {
    onLoad: onAlertsTableLoaded
  } = (0, _use_fetch_notes.useFetchNotes)();
  const endpointDetailsHref = endpointId => getAppUrl({
    path: (0, _routing.getEndpointDetailsPath)({
      name: 'endpointActivityLog',
      selected_endpoint: endpointId
    })
  });
  const refreshRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    dispatch(_store.timelineActions.createTimeline({
      id: _timeline.TimelineId.casePage,
      columns: [],
      dataViewId: null,
      indexNames: [],
      show: false
    }));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_endpoint.CaseDetailsRefreshContext.Provider, {
    value: refreshRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }, cases.ui.getCases({
    basePath: _constants.CASES_PATH,
    owner: [_constants.APP_ID],
    features: {
      ..._.CASES_FEATURES,
      metrics: [_common.CaseMetricsFeature.ALERTS_COUNT, _common.CaseMetricsFeature.ALERTS_USERS, _common.CaseMetricsFeature.ALERTS_HOSTS, _common.CaseMetricsFeature.CONNECTORS, _common.CaseMetricsFeature.LIFESPAN],
      alerts: {
        isExperimental: false
      },
      events: {
        enabled: true
      }
    },
    refreshRef,
    actionsNavigation: {
      href: endpointDetailsHref,
      onClick: (endpointId, e) => {
        if (e) {
          e.preventDefault();
        }
        return navigateTo({
          path: (0, _routing.getEndpointDetailsPath)({
            name: 'endpointActivityLog',
            selected_endpoint: endpointId
          })
        });
      }
    },
    ruleDetailsNavigation: {
      onClick: onRuleDetailsClick
    },
    showAlertDetails,
    timelineIntegration: {
      editor_plugins: {
        parsingPlugin: timelineMarkdownPlugin.parser,
        processingPluginRenderer: timelineMarkdownPlugin.renderer,
        uiPlugin: timelineMarkdownPlugin.plugin({
          interactionsUpsellingMessage,
          canSeeTimeline
        })
      },
      hooks: {
        useInsertTimeline: _use_insert_timeline.useInsertTimeline
      }
    },
    useFetchAlertData: _use_fetch_alert_data.useFetchAlertData,
    onAlertsTableLoaded,
    permissions: userCasesPermissions,
    renderAlertsTable,
    renderEventsTable: _table.EventsTableForCases
  })), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants.SecurityPageName.case,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }));
};
const Cases = exports.Cases = /*#__PURE__*/_react.default.memo(CaseContainerComponent);