"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAttackDiscoveryHistoryTimerange = void 0;
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _elasticAssistant = require("@kbn/elastic-assistant");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_HISTORY_END = 'now';
const DEFAULT_HISTORY_START = 'now-24h';
const useAttackDiscoveryHistoryTimerange = () => {
  // history time selection:
  const [historyStart, setHistoryStart] = (0, _useLocalStorage.default)(`${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.ATTACK_DISCOVERY_STORAGE_KEY}.${_elasticAssistant.HISTORY_START_LOCAL_STORAGE_KEY}`, DEFAULT_HISTORY_START);
  const [historyEnd, setHistoryEnd] = (0, _useLocalStorage.default)(`${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.ATTACK_DISCOVERY_STORAGE_KEY}.${_elasticAssistant.HISTORY_END_LOCAL_STORAGE_KEY}`, DEFAULT_HISTORY_END);
  return {
    historyStart: historyStart !== null && historyStart !== void 0 ? historyStart : DEFAULT_HISTORY_START,
    setHistoryStart,
    historyEnd: historyEnd !== null && historyEnd !== void 0 ? historyEnd : DEFAULT_HISTORY_END,
    setHistoryEnd
  };
};
exports.useAttackDiscoveryHistoryTimerange = useAttackDiscoveryHistoryTimerange;